--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]


local localmodname = "awuuwa_biomes_resource_maple"

--[[minetest.register_node(localmodname .. ":maple_tree_trunk_pointer", {
	description = "pointer to the tree trunk",
	tiles = {"default_bush_stem.png"},
	groups = {dig_immediate = 3},
})]]


local localwhichtreetrunktouse = "oak_tree:oak_tree"
local localwhichmapleleaves = localmodname .. ":maple_leaves_red"
--local localwhichmapleleavestexture = "default_leaves.png^[colorize:#FF0000:80"
if minetest.get_modpath("maple") then
localwhichmapleleaves = "maple:maple_leaves"
localwhichtreetrunktouse = "maple:maple_tree"
--localwhichmapleleavestexture = "maple_leaves.png^[colorize:#FF0000:90"
else
	if minetest.get_modpath("xcompat") then
		local localxcompatmaterials = xcompat.materials
		localwhichtreetrunktouse = localxcompatmaterials.apple_log
	end
	if localwhichtreetrunktouse == "default:tree" then--This is here because if xcompat sets it to default, that either means default is present which is checked below in which case it will be set to default tree below, or alternatively xcompat couldn't find a suitable tree and it defaults to default tree even if default isn't present, in which case oak tree is made the actual default again for the error check further below
		localwhichtreetrunktouse = "oak_tree:oak_tree"
	end
	if minetest.get_modpath("default") then
	    localwhichtreetrunktouse = "default:tree"
	end
	if minetest.get_modpath("mcl_core") then
		localwhichtreetrunktouse = "mcl_core:tree"
	end
	if minetest.get_modpath("mcl_trees") then
	    localwhichtreetrunktouse = "mcl_trees:tree_oak"
	end
end
if localwhichtreetrunktouse == "oak_tree:oak_tree" and not minetest.get_modpath("oak_tree") then
error("You need one of the following for awuuwa's Biomes Maple Resource which wants a tree trunk for the maple tree: default, maple, oak_tree, xcompat (and using game it supports), mcl_core (VoxeLibre) or mcl_trees (MineClonia and derivatives)")
end


minetest.register_alias(localmodname .. ":maple_tree_trunk_pointer", localwhichtreetrunktouse)


minetest.register_node(localmodname .. ":maple_leaves_red", {
	description = "Maple Leaves Red",
	drawtype = "allfaces_optional",
	tiles = {"awuuwa_biomes_red_maple_leaves.png"},
	waving = 1,
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = localwhichmapleleaves,
	sounds = default.node_sound_leaves_defaults(),
	after_place_node = default.after_place_leaves,
})
