--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]


local localmodname = "awuuwa_biomes_shield"
local localbiomename = "awuuwa_biomes_shield"
local localtargetedbiomes = {localbiomename}

local localwhichdirt = "default:dirt"
local localwhichclay = "default:clay"
local localwhichwater = "default:water_source"
local localwhichcobble = "default:cobble"
local localwhichdirtwithgrass = "default:dirt_with_grass"

if minetest.get_modpath("xcompat") then
local localxcompatmaterials = xcompat.materials
localwhichdirt = localxcompatmaterials.dirt
localwhichclay = localxcompatmaterials.clay
localwhichwater = localxcompatmaterials.water_source
localwhichcobble = localxcompatmaterials.cobble
localwhichdirtwithgrass = localxcompatmaterials.dirt_with_grass
end
local localwhichmossycobble = localwhichcobble
if minetest.get_modpath("default") then
localwhichmossycobble = "default:mossycobble"
elseif minetest.get_modpath("mcl_core") then
localwhichmossycobble = "mcl_core:mossycobble"
end


local localbiomeacceptedgrounds = {localwhichdirtwithgrass, localwhichdirt}



local modpath = minetest.get_modpath(minetest.get_current_modname())
local sprucetreemodpath = minetest.get_modpath("spruce_tree")

minetest.register_biome({
	name = localbiomename,
	node_top = localwhichdirtwithgrass,
	depth_top = 1,
	node_filler = localwhichdirt,
	depth_filler = 3,
	node_riverbed = localwhichdirt,
	depth_riverbed = 2,
--	node_cave_liquid = "default:water_source",
	node_dungeon = localwhichcobble,
	node_dungeon_alt = localwhichmossycobble,
	vertical_blend = 1,
--	node_river_water = "default:water_source",
	y_max = 160,
	y_min = 9,
    heat_point = 46,
    humidity_point = 94,
--[[
    heat_point = 80,
    humidity_point = 98,
]]
})


minetest.register_decoration({
	name = localmodname .. ":spruce_tree1",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .0015,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = sprucetreemodpath .. "/schematics/sprucetree1.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	name = localmodname .. ":spruce_tree2",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .004,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = sprucetreemodpath .. "/schematics/sprucetree2.mts",
	flags = "place_center_x, place_center_z",
})
minetest.register_decoration({
	name = localmodname .. ":spruce_tree3",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .005,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = sprucetreemodpath .. "/schematics/sprucetree3.mts",
	flags = "place_center_x, place_center_z",
})


minetest.register_decoration({
	name = localmodname .. ":spruce_tree4",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .004,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = sprucetreemodpath .. "/schematics/sprucetree4.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	name = localmodname .. ":spruce_tree0",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .001,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("spruce_tree") .. "/schematics/spruce_tree.mts",
	flags = "place_center_x, place_center_z",
})





minetest.register_decoration({
	name = localmodname .. ":small_pine_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .0001,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("default") .. "/schematics/small_pine_tree.mts",
	flags = "place_center_x, place_center_z",
})


minetest.register_decoration({
	name = localmodname .. ":bush",
	deco_type = "schematic",
	place_on = {"default:dirt_with_grass", "swamp:dirt_with_swamp_grass"},
	sidelen = 16,
	fill_ratio = 0.1,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 1,
	schematic = minetest.get_modpath("default") .. "/schematics/pine_bush.mts",
	flags = "place_center_x, place_center_z",
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = localtargetedbiomes,
	decoration = {
		"default:fern_1",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = localtargetedbiomes,
	decoration = {
		"awuuwa_biomes_resource_plants:plant",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.003,
	biomes = localtargetedbiomes,
	decoration = {
		"awuuwa_biomes_resource_moss:stone_with_moss",
	}
})

for i = 1, 5 do
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.09,
	biomes = localtargetedbiomes,
	decoration = {
		"default:grass_" .. 5 - i,
	}
})
end
