--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]


local localbiomename = "awuuwa_biomes_the_great_forest"
local localmodname = "awuuwa_biomes_the_great_forest"
local localtargetedbiomes = {localbiomename}

local localwhichdirt = "default:dirt"
local localwhichclay = "default:clay"
local localwhichwater = "default:water_source"
local localwhichcobble = "default:cobble"
local localwhichdirtwithgrass = "default:dirt_with_grass"

if minetest.get_modpath("xcompat") then
local localxcompatmaterials = xcompat.materials
localwhichdirt = localxcompatmaterials.dirt
localwhichclay = localxcompatmaterials.clay
localwhichwater = localxcompatmaterials.water_source
localwhichcobble = localxcompatmaterials.cobble
localwhichdirtwithgrass = localxcompatmaterials.dirt_with_grass
end

local localbiomeacceptedgrounds = {localwhichdirtwithgrass}




local modpath = minetest.get_modpath(minetest.get_current_modname())
--local mushroomsresourcemodpath = minetest.get_modpath("awuuwa_biomes_resource_mushrooms")
local maplemodpath = minetest.get_modpath("maple")
local oaktreemodpath = minetest.get_modpath("oak_tree")


minetest.register_biome({
	name = localbiomename,
	node_top = localwhichdirtwithgrass,
	depth_top = 1,
	node_filler = localwhichdirt,
	depth_filler = 3,
	node_riverbed = localwhichdirt,
	depth_riverbed = 2,
	node_cave_liquid = localwhichwater,
	node_dungeon = localwhichcobble,
	node_dungeon_alt = localwhichcobble,
	vertical_blend = 1,
	y_max = 60,
	y_min = 9,
    heat_point = 62,
    humidity_point = 69,
--[[
    heat_point = 80,
    humidity_point = 98,
]]
})


minetest.register_decoration({
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .04,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = oaktreemodpath .. "/schematics/oak_tree.mts",
	flags = "place_center_x, place_center_z",
--	place_offset_y = 1,
})

if maplemodpath then
minetest.register_decoration({
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .01,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = maplemodpath .. "/schematics/maple_tree.mts",
	flags = "place_center_x, place_center_z",
})
end

minetest.register_decoration({
	name = "awuuwa_biomes_the_great_forest:apple_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .006,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("default") .. "/schematics/apple_tree.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
	name = "awuuwa_biomes_the_great_forest:aspen_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .003,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 1,
	schematic = minetest.get_modpath("default") .. "/schematics/aspen_tree.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	name = "awuuwa_biomes_the_great_forest:spruce_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .001,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("spruce_tree") .. "/schematics/spruce_tree.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	name = "awuuwa_biomes_the_great_forest:pine_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .0005,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("default") .. "/schematics/pine_tree.mts",
	flags = "place_center_x, place_center_z",
})
minetest.register_decoration({
	name = "awuuwa_biomes_the_great_forest:small_pine_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .0005,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("default") .. "/schematics/small_pine_tree.mts",
	flags = "place_center_x, place_center_z",
})


minetest.register_decoration({
	name = "awuuwa_biomes_the_great_forest:apple_log",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	place_offset_y = 1,
	sidelen = 16,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = minetest.get_modpath("default") .. "/schematics/apple_log.mts",
	flags = "place_center_x",
	rotation = "random",
	spawn_by = localwhichdirtwithgrass,
	num_spawn_by = 8,
})

minetest.register_decoration({
	name = "awuuwa_biomes_the_great_forest:pine_log",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	place_offset_y = 1,
	sidelen = 80,
	fill_ratio = 0.0002,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 4,
	schematic = minetest.get_modpath("default") .. "/schematics/pine_log.mts",
	flags = "place_center_x",
	rotation = "random",
	spawn_by = localwhichdirtwithgrass,
	num_spawn_by = 8,
})


--[[minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = localtargetedbiomes,
	decoration = {
		"default:fern_1",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = localtargetedbiomes,
	decoration = {
		"awuuwa_biomes_resource_plants:plant",
	}
})
]]
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.003,
	biomes = localtargetedbiomes,
	decoration = {
		"awuuwa_biomes_resource_moss:stone_with_moss",
	}
})

if minetest.get_modpath("default") then
for i = 1, 5 do
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.09,
	biomes = localtargetedbiomes,
	decoration = {
		"default:grass_" .. i,
	}
})
end
end

--[[minetest.register_ore({
	ore_type        = "blob",
	ore             = "awuuwa_biomes_resource_moss:dirt_with_moss",
	wherein         = localbiomeacceptedgrounds,
	clust_scarcity  = 16 * 16 * 16,
	clust_size      = 5,
	y_max           = 31000,
	y_min           = 0,
	noise_threshold = 0.0,
	noise_params    = {
		offset = 0.5,
		scale = 0.2,
		spread = {x = 5, y = 5, z = 5},
		seed = -5555,
		octaves = 1,
		persist = 0.0
	},
})]]

--[[
minetest.register_decoration({
	name = "awuuwa_biomes_the_great_forest:red_mushroom_1",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
    fill_ratio = 0.00013,
	biomes = localtargetedbiomes,
--	y_max = 100,
--	y_min = 1,
	schematic = mushroomsresourcemodpath .. "/schematics/red_mushroom_1.mts",
	flags = "place_center_x, place_center_z",
--	rotation = "random"
})]]
