--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]


local localmodname = "awuuwa_biomes_winter_forest"
local localbiomename = "awuuwa_biomes_winter_forest"
local localtargetedbiomes = {localbiomename}

local localwhichdirt = "default:dirt"
local localwhichclay = "default:clay"
local localwhichwater = "default:water_source"
local localwhichcobble = "default:cobble"
local localsoiltoplayer = "default:dirt_with_snow"

if minetest.get_modpath("xcompat") then
local localxcompatmaterials = xcompat.materials
localwhichdirt = localxcompatmaterials.dirt
localwhichclay = localxcompatmaterials.clay
localwhichwater = localxcompatmaterials.water_source
localwhichcobble = localxcompatmaterials.cobble
localsoiltoplayer = localxcompatmaterials.dirt_with_grass
end
local localwhichmossycobble = localwhichcobble
if minetest.get_modpath("default") then
localwhichmossycobble = "default:mossycobble"
elseif minetest.get_modpath("mcl_core") then
localwhichmossycobble = "mcl_core:mossycobble"
end


local localbiomeacceptedgrounds = {localsoiltoplayer}



local modpath = minetest.get_modpath(minetest.get_current_modname())
--local mushroomsresourcemodpath = minetest.get_modpath("awuuwa_biomes_resource_mushrooms")

minetest.register_biome({
	name = localbiomename,
	node_dust = "default:snow",
	node_top = localsoiltoplayer,
	depth_top = 1,
	node_filler = localwhichdirt,
	depth_filler = 3,
	node_riverbed = localwhichclay,
	depth_riverbed = 2,
--	node_cave_liquid = "default:water_source",
	node_dungeon = localwhichcobble,
	node_dungeon_alt = localwhichmossycobble,
	vertical_blend = 1,
--	node_river_water = "default:water_source",
	y_max = 60,
	y_min = 9,
    heat_point = 28,
    humidity_point = 72,
--[[
    heat_point = 80,
    humidity_point = 98,
]]
})

--[[	minetest.register_decoration({
		name = localmodname .. ":glassi",
		deco_type = "schematic",
		place_on = localbiomeacceptedgrounds
		sidelen = 16,
    fill_ratio = 0.25,
		biomes = localtargetedbiomes,
		y_max = 10,
		y_min = -100,
		flags = "force_placement",
		schematic = modpath .. "/schematics/glasspillar.mts",
	})]]

minetest.register_decoration({
	name = localmodname .. ":pine_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .018,
--[[	noise_params = {
		offset = 0.010,
		scale = 0.048,
		spread = {x = 250, y = 250, z = 250},
		seed = 2,
		octaves = 3,
		persist = 0.66
	},]]
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 2,
	schematic = minetest.get_modpath("default") .. "/schematics/pine_tree.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	name = localmodname .. ":spruce_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .018,
--[[	noise_params = {
		offset = 0.010,
		scale = 0.048,
		spread = {x = 250, y = 250, z = 250},
		seed = 2,
		octaves = 3,
		persist = 0.66
	},]]
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 2,
	schematic = minetest.get_modpath("spruce_tree") .. "/schematics/spruce_tree.mts",
	flags = "place_center_x, place_center_z",
})
minetest.register_decoration({
	name = localmodname .. ":small_pine_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .018,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 4,
	schematic = minetest.get_modpath("default") .. "/schematics/small_pine_tree.mts",
	flags = "place_center_x, place_center_z",
})




minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.015,
	biomes = localtargetedbiomes,
	decoration = {
		"default:snowblock",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.1,
	biomes = localtargetedbiomes,
	decoration = {
		"default:snow",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.015,
	biomes = localtargetedbiomes,
	decoration = {
		"default:stone",
	}
})
--[[minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = localtargetedbiomes,
	decoration = {
		"default:fern_1", "default:fern_2", "default:fern_3",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = localtargetedbiomes,
	decoration = {
		"awuuwa_biomes_resource_plants:plant",
	}
})
]]
