--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]


local localwhichdirt = "default:dirt"
local localwhichclay = "default:clay"
local localwhichwater = "default:water_source"
local localwhichcobble = "default:cobble"

if minetest.get_modpath("xcompat") then
local localxcompatmaterials = xcompat.materials
localwhichdirt = localxcompatmaterials.dirt
localwhichclay = localxcompatmaterials.clay
localwhichwater = localxcompatmaterials.water_source
localwhichcobble = localxcompatmaterials.cobble
end

local localmodname = "awuuwa_biomes_coniferous_1"
local localtargetedbiomename = "awuuwa_biomes_coniferous_1"

local modpath = minetest.get_modpath(minetest.get_current_modname())
local mushroomsresourcemodpath = minetest.get_modpath("awuuwa_biomes_resource_mushrooms")

minetest.register_biome({
	name = localtargetedbiomename,
	node_top = "default:dirt_with_coniferous_litter",
	depth_top = 1,
	node_filler = localwhichdirt,
	depth_filler = 3,
	node_riverbed = localwhichclay,
	depth_riverbed = 2,
	node_cave_liquid = localwhichwater,
	node_dungeon = localwhichcobble,
	node_dungeon_alt = localwhichcobble,
	vertical_blend = 1,
--	node_river_water = "default:water_source",
	y_max = 60,
	y_min = 9,
    heat_point = 46,
    humidity_point = 72,
--[[
    heat_point = 80,
    humidity_point = 98,
]]
})

--[[	minetest.register_decoration({
		name = "awuuwa_biomes_coniferous_1:glassi",
		deco_type = "schematic",
		place_on = {"default:dirt_with_coniferous_litter"},
		sidelen = 16,
    fill_ratio = 0.25,
		biomes = {localtargetedbiomename},
		y_max = 10,
		y_min = -100,
		flags = "force_placement",
		schematic = modpath .. "/schematics/glasspillar.mts",
	})]]

local localbiomeacceptedgrounds = {"default:dirt_with_snow", "default:dirt_with_coniferous_litter"}

minetest.register_decoration({
	name = localmodname .. ":red_mushroom_1",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
    fill_ratio = 0.00013,
	biomes = {localtargetedbiomename},
--	y_max = 100,
--	y_min = 1,
	schematic = mushroomsresourcemodpath .. "/schematics/red_mushroom_1.mts",
	flags = "place_center_x, place_center_z",
--	rotation = "random"
})
minetest.register_decoration({
	name = localmodname .. ":pine_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .018,
--[[	noise_params = {
		offset = 0.010,
		scale = 0.048,
		spread = {x = 250, y = 250, z = 250},
		seed = 2,
		octaves = 3,
		persist = 0.66
	},]]
	biomes = {localtargetedbiomename},
	y_max = 31000,
	y_min = 2,
	schematic = minetest.get_modpath("default") .. "/schematics/pine_tree.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	name = localmodname .. ":spruce_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .018,
--[[	noise_params = {
		offset = 0.010,
		scale = 0.048,
		spread = {x = 250, y = 250, z = 250},
		seed = 2,
		octaves = 3,
		persist = 0.66
	},]]
	biomes = {localtargetedbiomename},
	y_max = 31000,
	y_min = 2,
	schematic = minetest.get_modpath("spruce_tree") .. "/schematics/spruce_tree.mts",
	flags = "place_center_x, place_center_z",
})






minetest.register_decoration({
	name = localmodname .. ":small_pine_tree",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = .018,
	biomes = {localtargetedbiomename},
	y_max = 31000,
	y_min = 4,
	schematic = minetest.get_modpath("default") .. "/schematics/small_pine_tree.mts",
	flags = "place_center_x, place_center_z",
})
minetest.register_decoration({
	name = localmodname .. ":pine_log",
	deco_type = "schematic",
	place_on = localbiomeacceptedgrounds,
	place_offset_y = 1,
	sidelen = 80,
	fill_ratio = 0.018,
	biomes = {localtargetedbiomename},
	y_max = 31000,
	y_min = 4,
	schematic = minetest.get_modpath("default") .. "/schematics/pine_log.mts",
	flags = "place_center_x",
	rotation = "random",
	spawn_by = localbiomeacceptedgrounds,
	num_spawn_by = 8,
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = {localtargetedbiomename},
	decoration = {
		"default:fern_1", "default:fern_2", "default:fern_3",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = {localtargetedbiomename},
	decoration = {
		"awuuwa_biomes_resource_plants:plant",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = {localtargetedbiomename},
	decoration = {
		"awuuwa_biomes_resource_plants:vegetation",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 0.003,
	biomes = {localtargetedbiomename},
	decoration = {
		"awuuwa_biomes_resource_moss:stone_with_moss",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = localbiomeacceptedgrounds,
	sidelen = 16,
	fill_ratio = 1,
	biomes = {localtargetedbiomename},
	decoration = {
		"default:grass_1",
	}
})

minetest.register_ore({
	ore_type        = "blob",
	ore             = "awuuwa_biomes_resource_moss:dirt_with_moss",
	wherein         = {"default:dirt_with_coniferous_litter"},
	clust_scarcity  = 16 * 16 * 16,
	clust_size      = 5,
	y_max           = 31000,
	y_min           = 0,
	noise_threshold = 0.0,
	noise_params    = {
		offset = 0.5,
		scale = 0.2,
		spread = {x = 5, y = 5, z = 5},
		seed = -5555,
		octaves = 1,
		persist = 0.0
	},
})
