--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]


local localtargetedbiomes = {"awuuwa_biomes_desert_pillars"}

--[[local localwhichdirt = "default:dirt"
local localwhichclay = "default:clay"
local localwhichwater = "default:water_source"
local localwhichcobble = "default:cobble"

if minetest.get_modpath("xcompat") then
local localxcompatmaterials = xcompat.materials
localwhichdirt = localxcompatmaterials.dirt
localwhichclay = localxcompatmaterials.clay
localwhichwater = localxcompatmaterials.water_source
localwhichcobble = localxcompatmaterials.cobble
end

local modpath = minetest.get_modpath(minetest.get_current_modname())
local mushroomsresourcemodpath = minetest.get_modpath("awuuwa_biomes_resource_mushrooms")
]]


local modpath = minetest.get_modpath(minetest.get_current_modname())

minetest.register_biome({
	name = "awuuwa_biomes_desert_pillars",
	node_top = "default:desert_sandstone",
	depth_top = 1,
	node_filler = "default:desert_sandstone",
	depth_filler = 1,
	node_riverbed = "default:desert_sand",
	node_stone = "default:desert_stone",
	depth_riverbed = 2,
	node_cave_liquid = "default:water_source",
	node_dungeon = "default:desert_sandstone_brick",
	node_dungeon_alt = "default:desert_sandstone",
	vertical_blend = 1,
--	node_river_water = "default:water_source",
	y_max = 31000,
	y_min = 5,
    heat_point = 90,
    humidity_point = 8,
--[[
    heat_point = 80,
    humidity_point = 98,
]]
})


minetest.register_decoration({
	name = "awuuwa_biomes_desert_pillars:pillar1",
	deco_type = "schematic",
	place_on = {"default:desert_sand", "default:desert_sandstone"},
	sidelen = 16,
	fill_ratio = .01,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = modpath .. "/schematics/sandpillar1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_desert_pillars:pillar2",
	deco_type = "schematic",
	place_on = {"default:desert_sand", "default:desert_sandstone"},
	sidelen = 16,
	fill_ratio = .01,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = modpath .. "/schematics/sandpillar2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_desert_pillars:pillar3",
	deco_type = "schematic",
	place_on = {"default:desert_sand", "default:desert_sandstone"},
	sidelen = 16,
	fill_ratio = .01,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = modpath .. "/schematics/sandpillar3.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_desert_pillars:pillar4",
	deco_type = "schematic",
	place_on = {"default:desert_sand", "default:desert_sandstone"},
	sidelen = 16,
	fill_ratio = .01,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 0,
	schematic = modpath .. "/schematics/sandpillar4.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:desert_sandstone"},
	sidelen = 4,
--	noise_params = {
--		offset = -1.5,
--		scale = -1.5,
--		spread = {x = 200, y = 200, z = 200},
--		seed = 329,
--		octaves = 4,
--		persist = 1.0
--	},
	fill_ratio = .76,
	biomes = localtargetedbiomes,
	y_max = 31000,
	y_min = 1,
	decoration = "default:desert_sand",
	place_offset_y = -1,
	flags = "force_placement",
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:desert_sand", "desert_sandstone"},
	sidelen = 16,
	fill_ratio = 0.01,
	biomes = localtargetedbiomes,
	decoration = {
		"default:dry_shrub",
	}
})
