--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]




local MODNAME = minetest.get_current_modname()
local MODPATH = minetest.get_modpath(MODNAME)
local S = minetest.get_translator(MODNAME)

local localmodname = "awuuwa_biomes_resource_fungi_forest"



local localwhichtreetrunktouse = "oak_tree:oak_tree"
	if minetest.get_modpath("xcompat") then
		local localxcompatmaterials = xcompat.materials
		localwhichtreetrunktouse = localxcompatmaterials.apple_log
	end
	if localwhichtreetrunktouse == "default:tree" then--This is here because if xcompat sets it to default, that either means default is present which is checked below in which case it will be set to default tree below, or alternatively xcompat couldn't find a suitable tree and it defaults to default tree even if default isn't present, in which case oak tree is made the actual default again for the error check further below
		localwhichtreetrunktouse = "oak_tree:oak_tree"
	end
	if minetest.get_modpath("swamp") then
		localwhichtreetrunktouse = "swamp:mangrove_tree"
	end
	if minetest.get_modpath("default") then
	    localwhichtreetrunktouse = "default:jungletree"
	end
	if minetest.get_modpath("mcl_core") then
		localwhichtreetrunktouse = "mcl_core:jungletree"
	end
	if minetest.get_modpath("mcl_trees") then
	    localwhichtreetrunktouse = "mcl_trees:tree_jungle"
	end

if localwhichtreetrunktouse == "oak_tree:oak_tree" and not minetest.get_modpath("oak_tree") then
error("You need one of the following for awuuwa's Biomes Fungi Forest Resource which wants a tree trunk for the fungi forest tree: default, swamp, oak_tree, xcompat (and using game it supports), mcl_core (VoxeLibre) or mcl_trees (MineClonia and derivatives)")
end

minetest.register_alias(localmodname .. ":tree_trunk_pointer", localwhichtreetrunktouse)

--[[minetest.register_node(localmodname .. ":tree_trunk_pointer", {
	description = "pointer to the tree trunk fungi forest",
	tiles = {"default_bush_stem.png"},
	groups = {dig_immediate = 3},
})]]




minetest.register_node(localmodname .. ":dirt_with_fungi_forest_grass", {
	description = S("dirt_with_fungi_forest_grass"),
	tiles = {"awuuwa_biomes_dirt_with_fungi_forest_grass.png", "default_dirt.png",
		{name = "default_dirt.png^awuuwa_biomes_dirt_with_fungi_forest_grass_side.png",
		tileable_vertical = false}},
	groups = {crumbly = 3, soil = 1, spreading_dirt_type = 1, supports_mushrooms = 1},
	drop = "default:dirt",
	sounds = default.node_sound_dirt_defaults({
		footstep = {name = "default_grass_footstep", gain = 0.25},
	}),
	soil = {
		base = localmodname .. ":dirt_with_fungi_forest_grass",
		dry = "farming:soil",
		wet = "farming:soil_wet"
	}
})

minetest.register_node(localmodname .. ":fungi_forest_leaves", {
	description = S("Fungi Tree Leaves"),
	drawtype = "allfaces_optional",
	tiles = {"awuuwa_biomes_fungi_forest_leaves.png"},
	waving = 1,
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{items = {localmodname .. ":fungi_tree_sapling"}, rarity = 20},
			{items = {localmodname .. ":fungi_forest_leaves"}}
		}
	},
	sounds = default.node_sound_leaves_defaults(),
	after_place_node = default.after_place_leaves,
})


minetest.register_node(localmodname .. ":fungi_tree_sapling", {
	description = S("Fungi Tree Sapling"),
	drawtype = "plantlike",
	tiles = {"awuuwa_biomes_fungi_forest_sapling.png"},
	inventory_image = "awuuwa_biomes_fungi_forest_sapling.png",
	wield_image = "awuuwa_biomes_fungi_forest_sapling.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, 7 / 16, 4 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3, flammable = 2,
		attached_node = 1, sapling = 1},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node(localmodname .. ":vine", {
	description = S("Fungi Forest Vine"),
	drawtype = "signlike",
	tiles = {"awuuwa_biomes_fungi_forest_leaves.png"},
	inventory_image = "awuuwa_biomes_fungi_forest_leaves.png",
	wield_image = "awuuwa_biomes_fungi_forest_leaves.png",
	waving = 1,
	paramtype = "light",
	paramtype2 = "wallmounted",
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted"
	},
	groups = {choppy = 3, oddly_breakable_by_hand = 1, flammable = 2},
	legacy_wallmounted = true,
	sounds = default.node_sound_leaves_defaults()
})




minetest.register_node(localmodname .. ":flower_1", {
	description = S("Fungi Forest Flower 1"),
	drawtype = "plantlike",
	tiles = {"awuuwa_biomes_fungi_forest_flower_1.png"},
	inventory_image = "awuuwa_biomes_fungi_forest_flower_1.png",
	wield_image = "awuuwa_biomes_fungi_forest_flower_1.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, 7 / 16, 4 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3, flammable = 2,
		attached_node = 1, sapling = 1},
	sounds = default.node_sound_leaves_defaults(),
})
