local S = minetest.get_translator(minetest.get_current_modname())
local D = mcl_util.get_dynamic_translator()
local doc_mod = minetest.get_modpath("doc")

local hc_desc = S("Terracotta is a basic building material. It comes in many different colors.")
local gt_desc = S("Glazed terracotta is a decorative block with a complex pattern. It can be rotated by placing it in different directions.")
local cp_desc = S("Concrete powder is used for creating concrete, but it can also be used as decoration itself. It comes in different colors. Concrete powder turns into concrete of the same color when it comes in contact with water.")
local c_desc = S("Concrete is a decorative block which comes in many different colors. It is notable for having a very strong and clean color.")
local cp_tt = S("Turns into concrete on water contact")

minetest.register_node("mcl_colorblocks:hardened_clay", {
	description = S("Terracotta"),
	_doc_items_longdesc = S("Terracotta is a basic building material which comes in many different colors. This particular block is uncolored."),
	tiles = {"hardened_clay.png"},
	groups = {pickaxey=1, hardened_clay=1,building_block=1, material_stone=1},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 4.2,
	_mcl_hardness = 1.25,
})

local on_rotate
if minetest.get_modpath("screwdriver") then
	on_rotate = screwdriver.rotate_simple
end

local canonical_color = "yellow"

for color,colordef in pairs(mcl_dyes.colors) do
	local is_canonical = color == canonical_color
	local sdesc_hc = D(colordef.readable_name .. " Terracotta")
	local sdesc_gt = D(colordef.readable_name .. " Glazed Terracotta")
	local sdesc_cp = D(colordef.readable_name .. " Concrete Powder")
	local sdesc_c = D(colordef.readable_name .. " Concrete")
	local ldesc_hc, ldesc_gt, ldesc_cp, ldesc_c
	local create_entry
	local ename_hc, ename_gt, ename_cp, ename_c
	local ltt_cp = cp_tt
	if is_canonical then
		ldesc_hc = hc_desc
		ldesc_gt = gt_desc
		ldesc_cp = cp_desc
		ldesc_c = c_desc
		ename_hc = S("Colored Terracotta")
		ename_gt = S("Glazed Terracotta")
		ename_cp = S("Concrete Powder")
		ename_c = S("Concrete")
		create_entry = true
	end

	-- Node Definition
	minetest.register_node("mcl_colorblocks:hardened_clay_"..color, {
		description = sdesc_hc,
		_doc_items_longdesc = ldesc_hc,
		_doc_items_create_entry = create_entry,
		_doc_items_entry_name = ename_hc,
		tiles = {"hardened_clay_stained_"..color..".png"},
		groups = {pickaxey=1, hardened_clay=1,building_block=1, material_stone=1},
		sounds = mcl_sounds.node_sound_stone_defaults(),
		_mcl_blast_resistance = 4.2,
		_mcl_hardness = 1.25,
		_mcl_cooking_output = "mcl_colorblocks:glazed_terracotta_"..color
	})


	local tex = "mcl_colorblocks_glazed_terracotta_"..color..".png"
	local texes = { tex, tex, tex.."^[transformR180", tex, tex.."^[transformR270", tex.."^[transformR90" }
	minetest.register_node("mcl_colorblocks:glazed_terracotta_"..color, {
		description = sdesc_gt,
		_doc_items_longdesc = ldesc_gt,
		_doc_items_create_entry = create_entry,
		_doc_items_entry_name = ename_gt,
		tiles = texes,
		groups = {handy=1,pickaxey=1, glazed_terracotta=1,building_block=1, material_stone=1, unsticky = 1},
		paramtype2 = "facedir",
		is_ground_content = false,
		sounds = mcl_sounds.node_sound_stone_defaults(),
		_mcl_blast_resistance = 1.4,
		_mcl_hardness = 1.4,
		on_rotate = on_rotate,
	})

	if not is_canonical and doc_mod then
		doc.add_entry_alias("nodes", "mcl_colorblocks:hardened_clay_"..canonical_color, "nodes", "mcl_colorblocks:hardened_clay_"..color)
		doc.add_entry_alias("nodes", "mcl_colorblocks:glazed_terracotta_"..canonical_color, "nodes", "mcl_colorblocks:glazed_terracotta_"..color)
	end

	-- Crafting recipes
	minetest.register_craft({
		output = "mcl_colorblocks:hardened_clay_"..color.." 8",
		recipe = {
				{"mcl_colorblocks:hardened_clay", "mcl_colorblocks:hardened_clay", "mcl_colorblocks:hardened_clay"},
				{"mcl_colorblocks:hardened_clay", "mcl_dyes:"..color, "mcl_colorblocks:hardened_clay"},
				{"mcl_colorblocks:hardened_clay", "mcl_colorblocks:hardened_clay", "mcl_colorblocks:hardened_clay"},
		},
	})
end
