mcl_copper = {}
local path = minetest.get_modpath(minetest.get_current_modname())
local S = minetest.get_translator(minetest.get_current_modname())
local D = mcl_util.get_dynamic_translator()

local showcopper = 1
if minetest.settings:get_bool("clonecraftlibre.showcopper") then
	showcopper = 0
else
	showcopper = 1
end

minetest.register_craftitem("mcl_copper:copper_ingot", {
	description = S("Copper Ingot"),
	inventory_image = "mcl_copper_ingot.png",
	groups = { craftitem = 1, not_in_creative_inventory = showcopper },
})

minetest.register_node("mcl_copper:stone_with_copper", {
	description = S("Copper Ore"),
	_doc_items_longdesc = S("Some copper contained in stone, it is pretty common and can be found below sea level."),
	tiles = {"default_stone.png^mcl_copper_ore.png"},
	groups = {pickaxey = 3, building_block = 1, material_stone = 1, blast_furnace_smeltable=1, not_in_creative_inventory = showcopper},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 3,
	_mcl_hardness = 3,
	_mcl_silk_touch_drop = true,
	_mcl_fortune_drop = mcl_core.fortune_drop_ore,
	_mcl_cooking_output = "mcl_copper:copper_ingot"
})

minetest.register_alias("mcl_copper:raw_copper", "mcl_copper:stone_with_copper")
minetest.register_alias("mcl_copper:block_raw", "mcl_copper:stone_with_copper")
