local S = minetest.get_translator(minetest.get_current_modname())

local description = S("Firework Rocket")

local function use_rocket(itemstack, user, duration)
	return itemstack
end


local function register_rocket(n, duration, force)
	minetest.register_craftitem("mcl_fireworks:rocket_" .. n, {
		description = description,
		_tt_help = S("Flight Duration: @1s", string.format("%.1f", duration)),
		inventory_image = "mcl_fireworks_rocket.png",
		on_use = function(itemstack, user, pointed_thing)
			return use_rocket(itemstack, user, duration)
		end,
		on_secondary_use = function(itemstack, user, pointed_thing)
			return use_rocket(itemstack, user, duration)
		end,
	})
end

minetest.register_alias("mcl_bows:rocket", "mcl_fireworks:rocket_2")

register_rocket(1, 2.2, 10)
register_rocket(2, 4.5, 20)
register_rocket(3, 6, 30)
