table.insert(ccl_overworld_biomes, "Mesa")
table.insert(ccl_overworld_biomes, "MesaBryce")
table.insert(ccl_overworld_biomes, "MesaPlateauF")
table.insert(ccl_overworld_biomes, "MesaPlateauFM")

if not mcl_vars.superflat then
	-- Mesa: Starts with a couple of sand-covered layers (the "sandlevel"),
	-- followed by terracotta with colorful (but imperfect) strata
	minetest.register_biome({
		name = "Mesa",
		node_top = "mcl_colorblocks:hardened_clay",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay",
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 11,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 0,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 19,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	-- Helper biome for the red sand at the bottom of Mesas.
	minetest.register_biome({
		name = "Mesa_sandlevel",
		node_top = "mcl_core:redsand",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay_orange",
		depth_filler = 3,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay_orange",
		y_min = -4,
		y_max = 10,
		humidity_point = 0,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 19,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Mesa_ocean",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -5,
		vertical_blend = 1,
		humidity_point = 0,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 19,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mesa Bryce: Variant of Mesa, but with perfect strata and a much smaller red sand desert
	minetest.register_biome({
		name = "MesaBryce",
		node_top = "mcl_colorblocks:hardened_clay",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay",
		node_riverbed = "mcl_colorblocks:hardened_clay",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = -5,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 20,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaBryce_sandlevel",
		node_top = "mcl_core:redsand",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay_orange",
		depth_filler = 3,
		node_riverbed = "mcl_colorblocks:hardened_clay",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay_orange",
		y_min = -4,
		y_max = 3,
		humidity_point = -5,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 20,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaBryce_ocean",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -5,
		vertical_blend = 1,
		humidity_point = -5,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 20,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})



	-- Mesa Plateau F
	-- Identical to Mesa below Y=30. At Y=30 and above there is a "dry" oak forest
	minetest.register_biome({
		name = "MesaPlateauF",
		node_top = "mcl_colorblocks:hardened_clay",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay",
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 11,
		y_max = 29,
		humidity_point = 0,
		heat_point = 60,
		vertical_blend = 0, -- we want a sharp transition
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	-- The oak forest plateau of this biome.
	-- This is a plateau for grass blocks, dry shrubs, tall grass, coarse dirt and oaks.
	-- Strata don't generate here.
	minetest.register_biome({
		name = "MesaPlateauF_grasstop",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 1,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 30,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 0,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaPlateauF_sandlevel",
		node_top = "mcl_core:redsand",
		depth_top = 2,
		node_filler = "mcl_colorblocks:hardened_clay_orange",
		depth_filler = 3,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay_orange",
		y_min = -5,
		y_max = 10,
		humidity_point = 0,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaPlateauF_ocean",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -6,
		vertical_blend = 1,
		humidity_point = 0,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mesa Plateau FM
	-- Dryer and more "chaotic"/"weathered down" variant of MesaPlateauF:
	-- oak forest is less dense, more coarse dirt, more erratic terrain, vertical blend, more red sand layers,
	-- red sand as ores, red sandstone at sandlevel
	minetest.register_biome({
		name = "MesaPlateauFM",
		node_top = "mcl_colorblocks:hardened_clay",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay",
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 2,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 12,
		y_max = 29,
		humidity_point = -5,
		heat_point = 60,
		vertical_blend = 5,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 22,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	-- Grass plateau
	minetest.register_biome({
		name = "MesaPlateauFM_grasstop",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:coarse_dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 30,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = -5,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 22,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaPlateauFM_sandlevel",
		node_top = "mcl_core:redsand",
		depth_top = 3,
		node_filler = "mcl_colorblocks:hardened_clay_orange",
		depth_filler = 3,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 2,
		node_stone = "mcl_colorblocks:hardened_clay",
		-- red sand has wider reach than in other mesa biomes
		y_min = -7,
		y_max = 11,
		humidity_point = -5,
		heat_point = 60,
		vertical_blend = 4,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 22,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaPlateauFM_ocean",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 3,
		y_min = OCEAN_MIN,
		y_max = -8,
		vertical_blend = 2,
		humidity_point = -5,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 22,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})




	-- Random coarse dirt floor in Mesa Plateau F
	minetest.register_ore({
		ore_type	= "sheet",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		column_height_max = 1,
		column_midpoint_factor = 0.0,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = 0.0,
		noise_params = {offset=0, scale=15, spread={x=250, y=250, z=250}, seed=24, octaves=3, persist=0.70},
		biomes = { "MesaPlateauF_grasstop" },
	})







	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		clust_scarcity	= 1500,
		clust_num_ores	= 25,
		clust_size	= 7,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauF_grasstop" },
	})
	minetest.register_ore({
		ore_type	= "sheet",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		column_height_max = 1,
		column_midpoint_factor = 0.0,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = -2.5,
		noise_params = {offset=1, scale=15, spread={x=250, y=250, z=250}, seed=24, octaves=3, persist=0.80},
		biomes = { "MesaPlateauFM_grasstop" },
	})
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		clust_scarcity	= 1800,
		clust_num_ores	= 65,
		clust_size	= 15,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauFM_grasstop" },
	})
	-- Occasionally dig out portions of MesaPlateauFM
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "air",
		wherein		= {"group:hardened_clay", "group:sand","mcl_core:coarse_dirt"},
		clust_scarcity	= 4000,
		clust_size	= 5,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauFM", "MesaPlateauFM_grasstop" },
	})
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:redsandstone",
		wherein		= {"mcl_colorblocks:hardened_clay_orange"},
		clust_scarcity	= 300,
		clust_size	= 8,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauFM_sandlevel" },
	})
	-- More red sand in MesaPlateauFM
	minetest.register_ore({
		ore_type	= "sheet",
		ore		= "mcl_core:redsand",
		wherein		= {"group:hardened_clay"},
		clust_scarcity	= 1,
		clust_num_ores	= 12,
		clust_size	= 10,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = 0.1,
		noise_params = {offset=0, scale=15, spread={x=130, y=130, z=130}, seed=95, octaves=3, persist=0.70},
		biomes = { "MesaPlateauFM" },
	})
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:redsand",
		wherein		= {"group:hardened_clay"},
		clust_scarcity	= 1500,
		clust_size	= 4,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauFM", "MesaPlateauFM_grasstop", "MesaPlateauFM_sandlevel" },
	})

	-- For a transition from stone to hardened clay in mesa biomes that is not perfectly flat
	minetest.register_ore({
		ore_type = "stratum",
		ore = "mcl_core:stone",
		wherein = {"group:hardened_clay"},
		noise_params = {offset=-6, scale=2, spread={x=25, y=25, z=25}, octaves=1, persist=0.60},
		stratum_thickness = 8,
		biomes = {
			"Mesa_sandlevel", "Mesa_ocean",
			"MesaBryce_sandlevel", "MesaBryce_ocean",
			"MesaPlateauF_sandlevel", "MesaPlateauF_ocean",
			"MesaPlateauFM_sandlevel", "MesaPlateauFM_ocean",
		},
		y_min = -4,
		y_max = 0,

	})

	-- Mesa strata (registered as sheet ores)

	-- Helper function to create strata.
	local function stratum(y_min, height, color, seed, is_perfect)
		if not height then
			height = 1
		end
		if not seed then
			seed = 39
		end
		local y_max = y_min + height-1
		local perfect_biomes
		if is_perfect then
			-- "perfect" means no erosion
			perfect_biomes = { "MesaBryce", "Mesa", "MesaPlateauF", "MesaPlateauFM" }
		else
			perfect_biomes = { "MesaBryce" }
		end
		-- Full, perfect stratum
		minetest.register_ore({
			ore_type = "stratum",
			ore = "mcl_colorblocks:hardened_clay_"..color,
			-- Only paint uncolored so the biome can choose
			-- a color in advance.
			wherein = {"mcl_colorblocks:hardened_clay"},
			y_min = y_min,
			y_max = y_max,
			biomes = perfect_biomes,
		})
		if not is_perfect then
		-- Slightly eroded stratum, only minor imperfections
		minetest.register_ore({
			ore_type = "stratum",
			ore = "mcl_colorblocks:hardened_clay_"..color,
			wherein = {"mcl_colorblocks:hardened_clay"},
			y_min = y_min,
			y_max = y_max,
			biomes = { "Mesa", "MesaPlateauF" },
			noise_params = {
				offset = y_min+(y_max-y_min)/2,
				scale = 0,
				spread = {x = 50, y = 50, z = 50},
				seed = seed+4,
				octaves = 1,
				persist = 1.0
			},
			np_stratum_thickness = {
				offset = 1.28,
				scale = 1,
				spread = {x = 18, y = 18, z = 18},
				seed = seed+4,
				octaves = 3,
				persist = 0.8,
			},
		})
		-- Very eroded stratum, most of the color is gone
		minetest.register_ore({
			ore_type = "stratum",
			ore = "mcl_colorblocks:hardened_clay_"..color,
			wherein = {"mcl_colorblocks:hardened_clay"},
			y_min = y_min,
			y_max = y_max,
			biomes = { "MesaPlateauFM" },
			noise_params = {
				offset = y_min+(y_max-y_min)/2,
				scale = 0,
				spread = {x = 50, y = 50, z = 50},
				seed = seed+4,
				octaves = 1,
				persist = 1.0
			},
			np_stratum_thickness = {
				offset = 0.1,
				scale = 1,
				spread = {x = 28, y = 28, z = 28},
				seed = seed+4,
				octaves = 2,
				persist = 0.6,
			},
		})
		end

	end

	-- Hardcoded orange strata near sea level.

	-- For MesaBryce, since it has no sand at these heights
	stratum(4, 1, "orange", nil, true)
	stratum(7, 2, "orange", nil, true)

	-- 3-level stratum above the sandlevel (all mesa biomes)
	stratum(11, 3, "orange", nil, true)

	-- Create random strata for up to Y = 256.
	-- These strata are calculated based on the world seed and are global.
	-- They are thus different per-world.
	local mesapr = PcgRandom(minetest.get_mapgen_setting("seed"))

	--[[

	------ DANGER ZONE! ------

	The following code is sensitive to changes; changing any number may break
	mapgen consistency when the mapgen generates new mapchunks in existing
	worlds because the random generator will yield different results and the strata
	suddenly don't match up anymore. ]]

	-- Available Mesa colors:
	local mesa_stratum_colors = { "silver", "brown", "orange", "red", "yellow", "white" }

	-- Start level
	local y = 17

	-- Generate stratas
	repeat
		-- Each stratum has a color (duh!)
		local colorid = mesapr:next(1, #mesa_stratum_colors)

		-- … and a random thickness
		local heightrandom = mesapr:next(1, 12)
		local h
		if heightrandom == 12 then
			h = 4
		elseif heightrandom >= 10 then
			h = 3
		elseif heightrandom >= 8 then
			h = 2
		else
			h = 1
		end
		-- Small built-in bias: Only thin strata up to this Y level
		if y < 45 then
			h = math.min(h, 2)
		end

		-- Register stratum
		stratum(y, h, mesa_stratum_colors[colorid])

		-- Skip a random amount of layers (which won't get painted)
		local skiprandom = mesapr:next(1, 12)
		local skip
		if skiprandom == 12 then
			skip = 4
		elseif skiprandom >= 10 then
			skip = 3
		elseif skiprandom >= 5 then
			skip = 2
		elseif skiprandom >= 2 then
			skip = 1
		else
			-- If this happens, the next stratum will touch the previous one without gap
			skip = 0
		end

		-- Get height of next stratum or finish
		y = y + h + skip
	until y > 256

	--[[ END OF DANGER ZONE ]]

end
