table.insert(ccl_overworld_biomes, "MushroomIsland")

if not mcl_vars.superflat then

	local mod_mcl_mushrooms = minetest.get_modpath("mcl_mushrooms")
	local ratio_mushroom_mycelium = 0.002
	local ratio_mushroom_mycelium_huge = ratio_mushroom_mycelium * (11/12)
	local ratio_mushroom_mycelium_giant = ratio_mushroom_mycelium * (1/12)


	-- Mushroom Island / Mushroom Island Shore (rare)
	-- Not neccessarily an island at all, only named after The OG Game's biome
	minetest.register_biome({
		name = "MushroomIsland",
		node_top = "mcl_core:mycelium",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 4,
		-- Note: Limited in height!
		y_max = 20,
		vertical_blend = 1,
		humidity_point = 106,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 29,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	minetest.register_biome({
		name = "MushroomIslandShore",
		node_top = "mcl_core:mycelium",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = 3,
		humidity_point = 106,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 29,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MushroomIsland_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 106,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 29,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})



	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "mcl_core:mycelium" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_mycelium_huge,
		biomes = { "MushroomIsland", "MushroomIslandShore" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_huge_brown.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "mcl_core:mycelium" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_mycelium_giant,
		biomes = { "MushroomIsland", "MushroomIslandShore" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_giant_brown.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})



	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "mcl_core:mycelium" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_mycelium_huge,
		biomes = { "MushroomIsland", "MushroomIslandShore" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_huge_red.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "mcl_core:mycelium" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_mycelium_giant,
		biomes = { "MushroomIsland", "MushroomIslandShore" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_giant_red.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})





	local mushrooms = {"mcl_mushrooms:mushroom_red", "mcl_mushrooms:mushroom_brown"}
	for m=1, #mushrooms do
		-- Mushrooms in mushroom biome
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"mcl_core:mycelium"},
			sidelen = 80,
			fill_ratio = 0.009,
			biomes = {"MushroomIsland", "MushroomIslandShore"},
			noise_threshold = 2.0,
			y_min = mcl_vars.mg_overworld_min,
			y_max = mcl_vars.mg_overworld_max,
			decoration = mushrooms[m],
		})
	end

end
