--Add deep ocean and underground biomes automatically.
for i=1, #ccl_overworld_biomes do
	local biome = ccl_overworld_biomes[i]
	local localbiometable = minetest.registered_biomes[biome]
	if localbiometable then
		--Deep Ocean
		minetest.register_biome({
			name = biome .. "_deep_ocean",
			heat_point = localbiometable.heat_point,
			humidity_point = localbiometable.humidity_point,
			y_min = DEEP_OCEAN_MIN,
			y_max = DEEP_OCEAN_MAX,
			node_top = minetest.registered_biomes[biome.."_ocean"].node_top,
			depth_top = 2,
			node_filler = minetest.registered_biomes[biome.."_ocean"].node_filler,
			depth_filler = 3,
			node_riverbed = minetest.registered_biomes[biome.."_ocean"].node_riverbed,
			depth_riverbed = 2,
			vertical_blend = 5,
			_mcl_biome_type = localbiometable._mcl_biome_type,
			_mcl_palette_index = localbiometable._mcl_palette_index,
			_mcl_skycolor = ocean_skycolor,
			_mcl_fogcolor = overworld_fogcolor
		})

		--Underground biomes are used to identify the underground and to prevent nodes from the surface
		--(sand, dirt) from leaking into the underground.
		minetest.register_biome({
			name = biome .. "_underground",
			heat_point = localbiometable.heat_point,
			humidity_point = localbiometable.humidity_point,
			y_min = mcl_vars.mg_overworld_min_old,
			y_max = DEEP_OCEAN_MIN - 1,
			_mcl_biome_type = localbiometable._mcl_biome_type,
			_mcl_palette_index = localbiometable._mcl_palette_index,
			_mcl_skycolor = localbiometable._mcl_skycolor,
			_mcl_fogcolor = localbiometable._mcl_fogcolor,
		})
	end
end
