table.insert(ccl_overworld_biomes, "ExtremeHills")
table.insert(ccl_overworld_biomes, "ExtremeHillsM")
table.insert(ccl_overworld_biomes, "ExtremeHills+")

if not mcl_vars.superflat then

	local mod_mcl_core = minetest.get_modpath("mcl_core")
	-- Extreme Hills
	-- Sparsely populated grasslands with little tallgras and trees.
	minetest.register_biome({
		name = "ExtremeHills",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 10,
		heat_point = 45,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 6,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ExtremeHills_beach",
		node_top = "mcl_core:sand",
		depth_top = 2,
		depth_water_top = 1,
		node_filler = "mcl_core:sandstone",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = -4,
		y_max = 3,
		humidity_point = 10,
		heat_point = 45,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 6,
		_mcl_skycolor = beach_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ExtremeHills_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = OCEAN_MIN,
		y_max = -5,
		vertical_blend = 1,
		humidity_point = 10,
		heat_point = 45,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 6,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Extreme Hills M
	-- Just gravel.
	minetest.register_biome({
		name = "ExtremeHillsM",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:gravel",
		depth_riverbed = 3,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 0,
		heat_point = 25,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 7,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ExtremeHillsM_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 3,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 0,
		heat_point = 25,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 7,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Extreme Hills+
	-- This biome is near-identical to Extreme Hills on the surface but has snow-covered mountains with spruce/oak
	-- forests above a certain height.
	minetest.register_biome({
		name = "ExtremeHills+",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = 1,
		y_max = 41,
		humidity_point = 24,
		heat_point = 25,
		vertical_blend = 6,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 8,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	---- Sub-biome for Extreme Hills+ for those snow forests
	minetest.register_biome({
		name = "ExtremeHills+_snowtop",
		node_dust = "mcl_core:snow",
		node_top = "mcl_core:dirt_with_grass_snow",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 4,
		node_river_water = "mcl_core:ice",
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = 42,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 24,
		heat_point = 25,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 8,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ExtremeHills+_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 24,
		heat_point = 25,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 8,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})


	-- Rarely replace stone with stone monster eggs.
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_monster_eggs:monster_egg_stone",
		wherein        = "mcl_core:stone",
		clust_scarcity = 26 * 26 * 26,
		clust_num_ores = 3,
		clust_size     = 2,
		y_min          = mcl_vars.mg_overworld_min,
		y_max          = mcl_worlds.layer_to_y(61),
		biomes         = {
			"ExtremeHills", "ExtremeHills_beach", "ExtremeHills_ocean", "ExtremeHills_deep_ocean", "ExtremeHills_underground",
			"ExtremeHills+", "ExtremeHills+_ocean", "ExtremeHills+_deep_ocean", "ExtremeHills+_underground",
			"ExtremeHillsM", "ExtremeHillsM_ocean", "ExtremeHillsM_deep_ocean", "ExtremeHillsM_underground",
		},
	})


	-- Small dirt patches in Extreme Hills M
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:dirt",
		wherein		= {"mcl_core:gravel"},
		clust_scarcity	= 5000,
		clust_num_ores	= 12,
		clust_size	= 4,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = 0.2,
		noise_params = {offset=0, scale=5, spread={x=250, y=250, z=250}, seed=64, octaves=3, persist=0.60},
		biomes = { "ExtremeHillsM" },
	})
	minetest.register_decoration({
		--this decoration "hack" replaces the top layer of the above ore with grass when under air.
		deco_type = "simple",
		place_on = {"mcl_core:dirt"},
		fill_ratio = 10,
		biomes = { "ExtremeHillsM" },
		decoration = "mcl_core:dirt_with_grass",
		place_offset_y = -1,
		flags = "force_placement",
	})


	if minetest.get_modpath("mcl_trees") then
	if mod_mcl_core then
	for i=1, 4 do
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block", "mcl_core:dirt", },
			sidelen = 80,
			noise_params = {
				offset = -0.0007,
				scale = 0.001,
				spread = {x = 250, y = 250, z = 250},
				seed = 3,
				octaves = 3,
				persist = 0.6
			},
			biomes = {"ExtremeHills", "ExtremeHillsM", "ExtremeHills+", "ExtremeHills+_snowtop"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_oak_large_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
	end
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:dirt", },
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"ExtremeHills", "ExtremeHillsM", "ExtremeHills+", "ExtremeHills+_snowtop"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.006,
			scale = 0.002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"ExtremeHills+", "ExtremeHills+_snowtop"},
		y_min = 50,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	end

	mcl_quick_spruce(11000, 0.000025, "mcl_core_spruce_5.mts", {"ExtremeHills", "ExtremeHillsM"})
	mcl_quick_spruce(2500, 0.00005, "mcl_core_spruce_1.mts", {"ExtremeHills", "ExtremeHillsM"})
	mcl_quick_spruce(7000, 0.00005, "mcl_core_spruce_3.mts", {"ExtremeHills", "ExtremeHillsM"})
	mcl_quick_spruce(9000, 0.00005, "mcl_core_spruce_4.mts", {"ExtremeHills", "ExtremeHillsM"})

	mcl_quick_spruce(11000, 0.001, "mcl_core_spruce_5.mts", {"ExtremeHills+", "ExtremeHills+_snowtop"}, 50)
	mcl_quick_spruce(2500, 0.002, "mcl_core_spruce_1.mts", {"ExtremeHills+", "ExtremeHills+_snowtop"}, 50)
	mcl_quick_spruce(7000, 0.003, "mcl_core_spruce_3.mts", {"ExtremeHills+", "ExtremeHills+_snowtop"}, 50)
	mcl_quick_spruce(9000, 0.002, "mcl_core_spruce_4.mts", {"ExtremeHills+", "ExtremeHills+_snowtop"}, 50)
	end

	if minetest.get_modpath("mcl_flowers") then
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block"},
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.09,
			spread = {x = 15, y = 15, z = 15},
			seed = 420,
			octaves = 3,
			persist = 0.6,
		},
		biomes = {"ExtremeHills+_snowtop"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = {
			size = { x=1, y=2, z=1 },
			data = {
				{ name = "mcl_core:dirt_with_grass", force_place=true, },
				{ name = "mcl_flowers:tallgrass", param2 = minetest.registered_biomes["ExtremeHills+_snowtop"]._mcl_palette_index },
			},
		},
	})
	end
end
