table.insert(ccl_overworld_biomes, "IcePlainsSpikes")
local mod_mcl_structures = minetest.get_modpath("mcl_structures")

if not mcl_vars.superflat then
	-- Ice Plains Spikes (rare)
	minetest.register_biome({
		name = "IcePlainsSpikes",
		node_top = "mcl_core:snowblock",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_water_top = "mcl_core:ice",
		depth_water_top = 1,
		node_river_water = "mcl_core:ice",
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 24,
		heat_point = -5,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 2,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "IcePlainsSpikes_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 2,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_river_water = "mcl_core:ice",
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 24,
		heat_point = -5,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 2,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Large ice spike
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:snowblock", "mcl_core:snow", "group:grass_block_snow"},
		sidelen = 80,
		noise_params = {
			offset = 0.00040,
			scale = 0.001,
			spread = {x = 250, y = 250, z = 250},
			seed = 1133,
			octaves = 4,
			persist = 0.67,
		},
		biomes = {"IcePlainsSpikes"},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_ice_spike_large.mts",
		rotation = "random",
		flags = "place_center_x, place_center_z",
	})

	-- Small ice spike
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:snowblock", "mcl_core:snow", "group:grass_block_snow"},
		sidelen = 80,
		noise_params = {
			offset = 0.005,
			scale = 0.001,
			spread = {x = 250, y = 250, z = 250},
			seed = 1133,
			octaves = 4,
			persist = 0.67,
		},
		biomes = {"IcePlainsSpikes", "kusi", "vittu", "neekeri"},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_ice_spike_small.mts",
		rotation = "random",
		flags = "place_center_x, place_center_z",
	})
end
