local mod_mcl_core = minetest.get_modpath("mcl_core")
local mod_mcl_mushrooms = minetest.get_modpath("mcl_mushrooms")
local mod_mcl_structures = minetest.get_modpath("mcl_structures")


-- All mapgens

-- Template to register a grass or fern decoration
function mcl_biomes.register_grass_decoration(grasstype, offset, scale, biomes)
	local place_on, seed, node
	if grasstype == "fern" then
		node = "mcl_flowers:fern"
		place_on = {"group:grass_block_no_snow", "mcl_core:podzol"}
		seed = 333
	elseif grasstype == "tallgrass" then
		node = "mcl_flowers:tallgrass"
		place_on = {"group:grass_block_no_snow"}
		seed = 420
	end
	local noise = {
		offset = offset,
		scale = scale,
		spread = {x = 200, y = 200, z = 200},
		seed = seed,
		octaves = 3,
		persist = 0.6
	}
	for b=1, #biomes do
		local localbiometablething = minetest.registered_biomes[biomes[b]]
		local param2 = 0
		if localbiometablething then
			param2 = localbiometablething._mcl_palette_index or 0
		end
		minetest.register_decoration({
			deco_type = "simple",
			place_on = place_on,
			sidelen = 16,
			noise_params = noise,
			biomes = { biomes[b] },
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			decoration = node,
			param2 = param2,
		})
	end
end


	-- Oak
	-- Large oaks
	for i=1, 4 do
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
			sidelen = 80,
			noise_params = {
				offset = 0.000545,
				scale = 0.0011,
				spread = {x = 250, y = 250, z = 250},
				seed = 3 + 5 * i,
				octaves = 3,
				persist = 0.66
			},
			biomes = {"Forest"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_oak_large_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
	end
	-- Small “classic” oak (many biomes)
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.025,
			scale = 0.0022,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"Forest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.01,
			scale = 0.0022,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"FlowerForest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.015,
			scale = 0.002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"MesaPlateauF_grasstop"},
		y_min = 30,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.008,
			scale = 0.002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"MesaPlateauFM_grasstop"},
		y_min = 30,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:dirt", },
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.0002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"IcePlains"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.004,
		biomes = {"Jungle", "JungleM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.0004,
		biomes = {"JungleEdge", "JungleEdgeM", "Savanna"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})


	-- Rare balloon oak
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.002083,
			scale = 0.0022,
			spread = {x = 250, y = 250, z = 250},
			seed = 3,
			octaves = 3,
			persist = 0.6,
		},
		biomes = {"Forest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_balloon.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	-- Swamp oak
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.0055,
			scale = 0.0011,
			spread = {x = 250, y = 250, z = 250},
			seed = 5005,
			octaves = 5,
			persist = 0.6,
		},
		biomes = {"Swampland", "Swampland_shore"},
		y_min = 0,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_swamp.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	-- Jungle tree

	-- Huge jungle tree (4 variants)
	for i=1, 4 do
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
			sidelen = 80,
			fill_ratio = 0.0008,
			biomes = {"Jungle"},
			y_min = 4,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_huge_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
			sidelen = 80,
			fill_ratio = 0.003,
			biomes = {"JungleM"},
			y_min = 4,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_huge_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
	end

	-- Common jungle tree
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.025,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.015,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_2.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.005,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_3.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.005,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_4.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.025,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.0045,
		biomes = {"JungleEdge", "JungleEdgeM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.09,
		biomes = {"JungleM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_2.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	-- Huge spruce
	mcl_quick_spruce(3000, 0.0030, "mcl_core_spruce_huge_1.mts", {"MegaSpruceTaiga"})
	mcl_quick_spruce(4000, 0.0036, "mcl_core_spruce_huge_2.mts", {"MegaSpruceTaiga"})
	mcl_quick_spruce(6000, 0.0036, "mcl_core_spruce_huge_3.mts", {"MegaSpruceTaiga"})
	mcl_quick_spruce(6600, 0.0036, "mcl_core_spruce_huge_4.mts", {"MegaSpruceTaiga"})

	mcl_quick_spruce(3000, 0.0008, "mcl_core_spruce_huge_up_1.mts", {"MegaTaiga"})
	mcl_quick_spruce(4000, 0.0008, "mcl_core_spruce_huge_up_2.mts", {"MegaTaiga"})
	mcl_quick_spruce(6000, 0.0008, "mcl_core_spruce_huge_up_3.mts", {"MegaTaiga"})


	-- Common spruce
	mcl_quick_spruce(11000, 0.00150, "mcl_core_spruce_5.mts", {"Taiga", "ColdTaiga"})

	mcl_quick_spruce(2500, 0.00325, "mcl_core_spruce_1.mts", {"MegaSpruceTaiga", "MegaTaiga", "Taiga", "ColdTaiga"})
	mcl_quick_spruce(7000, 0.00425, "mcl_core_spruce_3.mts", {"MegaSpruceTaiga", "MegaTaiga", "Taiga", "ColdTaiga"})
	mcl_quick_spruce(9000, 0.00325, "mcl_core_spruce_4.mts", {"MegaTaiga", "Taiga", "ColdTaiga"})

	mcl_quick_spruce(9500, 0.00500, "mcl_core_spruce_tall.mts", {"MegaTaiga"})

	mcl_quick_spruce(5000, 0.00250, "mcl_core_spruce_2.mts", {"MegaSpruceTaiga", "MegaTaiga"})


	-- Small lollipop spruce
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:podzol"},
		sidelen = 16,
		noise_params = {
			offset = 0.004,
			scale = 0.0022,
			spread = {x = 250, y = 250, z = 250},
			seed = 2500,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"Taiga", "ColdTaiga"},
		y_min = 2,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_spruce_lollipop.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Matchstick spruce: Very few leaves, tall trunk
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:podzol"},
		sidelen = 80,
		noise_params = {
			offset = -0.025,
			scale = 0.025,
			spread = {x = 250, y = 250, z = 250},
			seed = 2566,
			octaves = 5,
			persist = 0.60,
		},
		biomes = {"Taiga", "ColdTaiga"},
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_spruce_matchstick.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Rare spruce in Ice Plains
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block"},
		sidelen = 16,
		noise_params = {
			offset = -0.00075,
			scale = -0.0015,
			spread = {x = 250, y = 250, z = 250},
			seed = 11,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"IcePlains"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_spruce_5.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Acacia (many variants)
	for a=1, 7 do
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"mcl_core:dirt_with_grass", "mcl_core:dirt", "mcl_core:coarse_dirt"},
			sidelen = 16,
			fill_ratio = 0.0002,
			biomes = {"Savanna", "SavannaM"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_acacia_"..a..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
	end

	-- Birch
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = 0.03,
			scale = 0.0025,
			spread = {x = 250, y = 250, z = 250},
			seed = 11,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"BirchForest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_birch.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = 0.03,
			scale = 0.0025,
			spread = {x = 250, y = 250, z = 250},
			seed = 11,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"BirchForestM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_birch_tall.mts",
		flags = "place_center_x, place_center_z",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.000333,
			scale = -0.0015,
			spread = {x = 250, y = 250, z = 250},
			seed = 11,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"Forest", "FlowerForest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_birch.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Dark Oak
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = 0.05,
			scale = 0.0015,
			spread = {x = 125, y = 125, z = 125},
			seed = 223,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"RoofedForest"},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_dark_oak.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})



	local ratio_mushroom = 0.0001
	local ratio_mushroom_huge = ratio_mushroom * (11/12)
	local ratio_mushroom_giant = ratio_mushroom * (1/12)

	-- Huge Brown Mushroom
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "group:grass_block_no_snow", "mcl_core:dirt" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_huge,
		biomes = { "RoofedForest" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_huge_brown.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "group:grass_block_no_snow", "mcl_core:dirt" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_giant,
		biomes = { "RoofedForest" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_giant_brown.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})

	-- Huge Red Mushroom
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "group:grass_block_no_snow", "mcl_core:dirt" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_huge,
		biomes = { "RoofedForest" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_huge_red.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "group:grass_block_no_snow", "mcl_core:dirt" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_giant,
		biomes = { "RoofedForest" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_giant_red.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})

	--Snow on snowy dirt
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:dirt_with_grass_snow"},
		sidelen = 80,
		fill_ratio = 10,
		flags = "all_floors",
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_core:snow",
	})

	--Mushrooms in caves
	minetest.register_decoration({
		deco_type = "simple",
		place_on = stonelike,
		sidelen = 80,
		fill_ratio = 0.009,
		noise_threshold = 2.0,
		flags = "all_floors",
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_mushrooms:mushroom_red",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = stonelike,
		sidelen = 80,
		fill_ratio = 0.009,
		noise_threshold = 2.0,
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_mushrooms:mushroom_brown",
	})

	-- Mossy cobblestone boulder (3×3)
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:podzol", "mcl_core:dirt", "mcl_core:coarse_dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.00015,
			scale = 0.001,
			spread = {x = 300, y = 300, z = 300},
			seed = 775703,
			octaves = 4,
			persist = 0.63,
		},
		biomes = {"MegaTaiga", "MegaSpruceTaiga"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_boulder.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	-- Small mossy cobblestone boulder (2×2)
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:podzol", "mcl_core:dirt", "mcl_core:coarse_dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.001,
			scale = 0.001,
			spread = {x = 300, y = 300, z = 300},
			seed = 775703,
			octaves = 4,
			persist = 0.63,
		},
		biomes = {"MegaTaiga", "MegaSpruceTaiga"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_boulder_small.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})



	-- Sugar canes
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:dirt", "mcl_core:coarse_dirt", "group:grass_block_no_snow", "group:sand", "mcl_core:podzol", "mcl_core:reeds"},
		sidelen = 16,
		noise_params = {
			offset = -0.3,
			scale = 0.7,
			spread = {x = 200, y = 200, z = 200},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_core:reeds",
		height = 1,
		height_max = 3,
		spawn_by = { "mcl_core:water_source", "group:frosted_ice" },
		num_spawn_by = 1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:dirt", "mcl_core:coarse_dirt", "group:grass_block_no_snow", "group:sand", "mcl_core:podzol", "mcl_core:reeds"},
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.5,
			spread = {x = 200, y = 200, z = 200},
			seed = 2,
			octaves = 3,
			persist = 0.7,
		},
		biomes = {"Swampland", "Swampland_shore"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_core:reeds",
		height = 1,
		height_max = 3,
		spawn_by = { "mcl_core:water_source", "group:frosted_ice" },
		num_spawn_by = 1,
	})

	-- Doubletall grass
	function mcl_biomes.register_doubletall_grass(offset, scale, biomes)

		for b=1, #biomes do
			local localbiometablething = minetest.registered_biomes[biomes[b]]
			local param2 = 0
			if localbiometablething then
				param2 = localbiometablething._mcl_palette_index or 0
			end
			minetest.register_decoration({
				deco_type = "schematic",
				schematic = {
					size = { x=1, y=3, z=1 },
					data = {
						{ name = "air", prob = 0 },
						{ name = "mcl_flowers:double_grass", param1=255, param2=param2 },
						{ name = "mcl_flowers:double_grass_top", param1=255, param2=param2 },
					},
				},
				place_on = {"group:grass_block_no_snow"},
				sidelen = 16,
				noise_params = {
					offset = offset,
					scale = scale,
					spread = {x = 200, y = 200, z = 200},
					seed = 420,
					octaves = 3,
					persist = 0.6,
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				biomes = { biomes[b] },
			})
		end
	end

	local register_doubletall_grass = mcl_biomes.register_doubletall_grass

	register_doubletall_grass(-0.01, 0.03, {"Taiga", "Forest", "FlowerForest", "BirchForest", "BirchForestM", "RoofedForest"})
	register_doubletall_grass(-0.002, 0.03, {"Plains", "SunflowerPlains"})
	register_doubletall_grass(-0.0005, -0.03, {"Savanna", "SavannaM"})

	-- Large ferns
	function mcl_biomes.register_double_fern(offset, scale, biomes)
		for b=1, #biomes do
			local localbiometablething = minetest.registered_biomes[biomes[b]]
			local param2 = 0
			if localbiometablething then
				param2 = localbiometablething._mcl_palette_index or 0
			end
			minetest.register_decoration({
				deco_type = "schematic",
				schematic = {
					size = { x=1, y=3, z=1 },
					data = {
						{ name = "air", prob = 0 },
						{ name = "mcl_flowers:double_fern", param1=255, param2=param2 },
						{ name = "mcl_flowers:double_fern_top", param1=255, param2=param2 },
					},
				},
				place_on = {"group:grass_block_no_snow", "mcl_core:podzol"},
				sidelen = 16,
				noise_params = {
					offset = offset,
					scale = scale,
					spread = {x = 250, y = 250, z = 250},
					seed = 333,
					octaves = 2,
					persist = 0.66,
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				biomes = biomes[b],
			})
		end
	end

	local register_double_fern = mcl_biomes.register_double_fern

	register_double_fern(0.01, 0.03, { "Jungle", "JungleM", "JungleEdge", "JungleEdgeM", "Taiga", "ColdTaiga", "MegaTaiga", "MegaSpruceTaiga" })
	register_double_fern(0.15, 0.1, { "JungleM" })

	-- Large flowers
	function mcl_biomes.register_large_flower(name, biomes, seed, offset, flower_forest_offset)
		local maxi
		if flower_forest_offset then
			maxi = 2
		else
			maxi = 1
		end
		for i=1, maxi do
			local o, b -- offset, biomes
			if i == 1 then
				o = offset
				b = biomes
			else
				o = flower_forest_offset
				b = { "FlowerForest" }
			end

			minetest.register_decoration({
				deco_type = "schematic",
				schematic = {
					size = {x = 1, y = 3, z = 1},
					data = {
						{name = "air", prob = 0},
						{name = "mcl_flowers:" .. name, param1 = 255, },
						{name = "mcl_flowers:" .. name .. "_top", param1 = 255, },
					},
				},
				place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},

				sidelen = 16,
				noise_params = {
					offset = o,
					scale = 0.01,
					spread = {x = 300, y = 300, z = 300},
					seed = seed,
					octaves = 5,
					persist = 0.62,
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				flags = "",
				biomes = b,
			})
		end
	end

	local register_large_flower = mcl_biomes.register_large_flower

	register_large_flower("rose_bush", {"Forest"}, 9350, -0.008, 0.003)
	register_large_flower("peony", {"Forest"}, 10450, -0.008, 0.003)
	register_large_flower("lilac", {"Forest"}, 10600, -0.007, 0.003)
	register_large_flower("sunflower", {"SunflowerPlains"}, 2940, 0.01)

	-- Jungle bush

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.0196,
			scale = 0.015,
			spread = {x = 250, y = 250, z = 250},
			seed = 2930,
			octaves = 4,
			persist = 0.6,
		},
		biomes = {"Jungle"},
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_bush_oak_leaves.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.0196,
			scale = 0.005,
			spread = {x = 250, y = 250, z = 250},
			seed = 2930,
			octaves = 4,
			persist = 0.6,
		},
		biomes = {"Jungle"},
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_bush_oak_leaves_2.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.05,
			scale = 0.025,
			spread = {x = 250, y = 250, z = 250},
			seed = 2930,
			octaves = 4,
			persist = 0.6,
		},
		biomes = {"JungleM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_bush_oak_leaves.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.0085,
			scale = 0.025,
			spread = {x = 250, y = 250, z = 250},
			seed = 2930,
			octaves = 4,
			persist = 0.6,
		},
		biomes = {"JungleEdge", "JungleEdgeM"},
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_bush_oak_leaves.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Lily pad

	local lily_schem = {
		{ name = "mcl_core:water_source" },
		{ name = "mcl_flowers:waterlily" },
	}

	-- Spawn them in shallow water at ocean level in Swampland.
	-- Tweak lilydepth to change the maximum water depth
	local lilydepth = 2

	for d=1, lilydepth do
		local height = d + 2
		local y = 1 - d
		table.insert(lily_schem, 1, { name = "air", prob = 0 })

		minetest.register_decoration({
			deco_type = "schematic",
			schematic = {
				size = { x=1, y=height, z=1 },
				data = lily_schem,
			},
			place_on = "mcl_core:dirt",
			sidelen = 16,
			noise_params = {
				offset = 0,
				scale = 0.3,
				spread = {x = 100, y = 100, z = 100},
				seed = 503,
				octaves = 6,
				persist = 0.7,
			},
			y_min = y,
			y_max = y,
			biomes = { "Swampland_shore" },
			rotation = "random",
		})
	end

	-- Melon
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = -0.01,
			scale = 0.006,
			spread = {x = 250, y = 250, z = 250},
			seed = 333,
			octaves = 3,
			persist = 0.6
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_farming:melon",
		biomes = { "Jungle" },
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.006,
			spread = {x = 250, y = 250, z = 250},
			seed = 333,
			octaves = 3,
			persist = 0.6
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_farming:melon",
		biomes = { "JungleM" },
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = -0.005,
			scale = 0.006,
			spread = {x = 250, y = 250, z = 250},
			seed = 333,
			octaves = 3,
			persist = 0.6
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_farming:melon",
		biomes = { "JungleEdge", "JungleEdgeM" },
	})

	-- Lots of melons in Jungle Edge M
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 80,
		noise_params = {
			offset = 0.013,
			scale = 0.006,
			spread = {x = 125, y = 125, z = 125},
			seed = 333,
			octaves = 3,
			persist = 0.6
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_farming:melon",
		biomes = { "JungleEdgeM" },
	})

	-- Pumpkin
	minetest.register_decoration({
		deco_type = "simple",
		decoration = "mcl_farming:pumpkin",
		param2 = 0,
		param2_max = 3,
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = -0.016,
			scale = 0.01332,
			spread = {x = 125, y = 125, z = 125},
			seed = 666,
			octaves = 6,
			persist = 0.666
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
	})

	-- Grasses and ferns
	local grass_forest = {"Plains", "Taiga", "Forest", "FlowerForest", "BirchForest", "BirchForestM", "RoofedForest", "Swampland" }
	local grass_mpf = {"MesaPlateauF_grasstop"}
	local grass_plains = {"Plains", "SunflowerPlains", "JungleEdge", "JungleEdgeM" }
	local grass_savanna = {"Savanna", "SavannaM"}
	local grass_sparse = {"ExtremeHills", "ExtremeHills+", "ExtremeHills+_snowtop", "ExtremeHillsM", "Jungle" }
	local grass_mpfm = {"MesaPlateauFM_grasstop" }

	local register_grass_decoration = mcl_biomes.register_grass_decoration
	register_grass_decoration("tallgrass", -0.03,  0.09, grass_forest)
	register_grass_decoration("tallgrass", -0.015, 0.075, grass_forest)
	register_grass_decoration("tallgrass", 0,      0.06, grass_forest)
	register_grass_decoration("tallgrass", 0.015,  0.045, grass_forest)
	register_grass_decoration("tallgrass", 0.03,   0.03, grass_forest)
	register_grass_decoration("tallgrass", -0.03, 0.09, grass_mpf)
	register_grass_decoration("tallgrass", -0.015, 0.075, grass_mpf)
	register_grass_decoration("tallgrass", 0, 0.06, grass_mpf)
	register_grass_decoration("tallgrass", 0.01, 0.045, grass_mpf)
	register_grass_decoration("tallgrass", 0.01, 0.05, grass_forest)
	register_grass_decoration("tallgrass", 0.03, 0.03, grass_plains)
	register_grass_decoration("tallgrass", 0.05, 0.01, grass_plains)
	register_grass_decoration("tallgrass", 0.07, -0.01, grass_plains)
	register_grass_decoration("tallgrass", 0.09, -0.03, grass_plains)
	register_grass_decoration("tallgrass", 0.18, -0.03, grass_savanna)
	register_grass_decoration("tallgrass", 0.05, -0.03, grass_sparse)
	register_grass_decoration("tallgrass", 0.05, 0.05, grass_mpfm)

	local fern_minimal = { "Jungle", "JungleM", "JungleEdge", "JungleEdgeM", "Taiga", "MegaTaiga", "MegaSpruceTaiga", "ColdTaiga" }
	local fern_low = { "Jungle", "JungleM", "JungleEdge", "JungleEdgeM", "Taiga", "MegaTaiga", "MegaSpruceTaiga" }
	local fern_Jungle = { "Jungle", "JungleM", "JungleEdge", "JungleEdgeM" }
	--local fern_JungleM = { "JungleM" },

	register_grass_decoration("fern", -0.03,  0.09, fern_minimal)
	register_grass_decoration("fern", -0.015, 0.075, fern_minimal)
	register_grass_decoration("fern", 0,      0.06, fern_minimal)
	register_grass_decoration("fern", 0.015,  0.045, fern_low)
	register_grass_decoration("fern", 0.03,   0.03, fern_low)
	register_grass_decoration("fern", 0.01, 0.05, fern_Jungle)
	register_grass_decoration("fern", 0.03, 0.03, fern_Jungle)
	register_grass_decoration("fern", 0.05, 0.01, fern_Jungle)
	register_grass_decoration("fern", 0.07, -0.01, fern_Jungle)
	register_grass_decoration("fern", 0.09, -0.03, fern_Jungle)
	register_grass_decoration("fern", 0.12, -0.03, {"JungleM"})


	local localiceplainstablething = minetest.registered_biomes["IcePlains"]
	local localiceplainsthingparam2 = 0
	if localiceplainstablething then
		localiceplainsthingparam2 = localiceplainstablething._mcl_palette_index or 0
	end
	-- Place tall grass on snow in Ice Plains and Extreme Hills+
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block"},
		sidelen = 16,
		noise_params = {
			offset = -0.08,
			scale = 0.09,
			spread = {x = 15, y = 15, z = 15},
			seed = 420,
			octaves = 3,
			persist = 0.6,
		},
		biomes = {"IcePlains"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = {
			size = { x=1, y=2, z=1 },
			data = {
				{ name = "mcl_core:dirt_with_grass", force_place=true, },
				{ name = "mcl_flowers:tallgrass", param2 = localiceplainsthingparam2 },
			},
		},
	})



	-- Small Mushrooms
	local mushrooms = {"mcl_mushrooms:mushroom_red", "mcl_mushrooms:mushroom_brown"}
	local mseeds = { 7133, 8244 }
	for m=1, #mushrooms do
		-- Mushrooms in Taiga
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"mcl_core:podzol"},
			sidelen = 80,
			fill_ratio = 0.003,
			biomes = {"MegaTaiga", "MegaSpruceTaiga"},
			y_min = mcl_vars.mg_overworld_min,
			y_max = mcl_vars.mg_overworld_max,
			decoration = mushrooms[m],
		})
		-- Mushrooms next to trees
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt", "mcl_core:podzol", "mcl_core:mycelium", "mcl_core:stone", "mcl_core:andesite", "mcl_core:diorite", "mcl_core:granite"},
			sidelen = 16,
			noise_params = {
				offset = 0,
				scale = 0.003,
				spread = {x = 250, y = 250, z = 250},
				seed = mseeds[m],
				octaves = 3,
				persist = 0.66,
			},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			decoration = mushrooms[m],
			spawn_by = { "mcl_trees:tree_oak", "mcl_trees:tree_spruce", "mcl_trees:tree_dark_oak", "mcl_trees:tree_birch" },
			num_spawn_by = 1,
		})

		-- More mushrooms in Swampland
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt", "mcl_core:podzol", "mcl_core:mycelium", "mcl_core:stone", "mcl_core:andesite", "mcl_core:diorite", "mcl_core:granite"},
			sidelen = 16,
			noise_params = {
				offset = 0.05,
				scale = 0.003,
				spread = {x = 250, y = 250, z = 250},
				seed = mseeds[m],
				octaves = 3,
				persist = 0.6,
			},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			decoration = mushrooms[m],
			biomes = { "Swampland"},
			spawn_by = { "mcl_trees:tree_oak", "mcl_trees:tree_spruce", "mcl_trees:tree_dark_oak", "mcl_trees:tree_birch" },
			num_spawn_by = 1,
		})
	end

	function mcl_biomes.register_flower(name, biomes, seed, is_in_flower_forest)
		if is_in_flower_forest == nil then
			is_in_flower_forest = true
		end
		if biomes then
			minetest.register_decoration({
				deco_type = "simple",
				place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
				sidelen = 16,
				noise_params = {
					offset = 0.0008,
					scale = 0.006,
					spread = {x = 100, y = 100, z = 100},
					seed = seed,
					octaves = 3,
					persist = 0.6
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				biomes = biomes,
				decoration = "mcl_flowers:"..name,
			})
		end
		if is_in_flower_forest then
			minetest.register_decoration({
				deco_type = "simple",
				place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
				sidelen = 80,
				noise_params= {
					offset = 0.0008*40,
					scale = 0.003,
					spread = {x = 100, y = 100, z = 100},
					seed = seed,
					octaves = 3,
					persist = 0.6,
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				biomes = {"FlowerForest"},
				decoration = "mcl_flowers:"..name,
			})
		end
	end

	local register_flower = mcl_biomes.register_flower

	local flower_biomes1 = {"Plains", "SunflowerPlains", "RoofedForest", "Forest", "BirchForest", "BirchForestM", "Taiga", "ColdTaiga", "Jungle", "JungleM", "JungleEdge", "JungleEdgeM", "Savanna", "SavannaM", "ExtremeHills", "ExtremeHillsM", "ExtremeHills+", "ExtremeHills+_snowtop" }

	register_flower("dandelion", flower_biomes1, 8)
	register_flower("poppy", flower_biomes1, 9439)

	local flower_biomes2 = {"Plains", "SunflowerPlains"}
	register_flower("tulip_red", flower_biomes2, 436)
	register_flower("tulip_orange", flower_biomes2, 536)
	register_flower("tulip_pink", flower_biomes2, 636)
	register_flower("tulip_white", flower_biomes2, 736)
	register_flower("azure_bluet", flower_biomes2, 800)
	register_flower("oxeye_daisy", flower_biomes2, 3490)

	register_flower("allium", nil, 0) -- flower Forest only
	register_flower("blue_orchid", {"Swampland"}, 64500, false)

	register_flower("lily_of_the_valley", nil, 325)
	register_flower("cornflower", flower_biomes2, 486)

