---------------------------------------------
-------------MOREBLOCKS
---------------------------------------------
if minetest.get_modpath("moreblocks") then

	stairsplus:register_all("dorwinion_brick", "stone", "variety:dorwinion_brick", {
		description = "Dorwinion Brick",
	tiles = {"dorwinion_brick.png"},
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
	})

	stairsplus:register_all("dorwinion", "stone", "variety:dorwinion", {
		description = "Dorwinion",
	tiles = {"dorwinion.png"},
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
	})

	stairsplus:register_all("dorwinion_carved", "stone", "variety:dorwinion_carved", {
		description = "Dorwinion Carved",
	tiles = {"dorwinion_carved.png"},
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
	})

	stairsplus:register_all("dorwinion_brick_cracked", "stone", "variety:dorwinion_brick_cracked", {
		description = "Dorwinion Brick Cracked",
	tiles = {"dorwinion_brick_cracked.png"},
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
	})

	stairsplus:register_all("dorwinion_brick_with_flowers", "stone", "variety:dorwinion_brick_with_flowers", {
		description = "Dorwinion Brick With Flowers",
	tiles = {"dorwinion_brick_with_flowers.png"},
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
	})

	stairsplus:register_all("dorwinion_brick_with_moss", "stone", "variety:dorwinion_brick_with_moss", {
		description = "Dorwinion Brick With Moss",
	tiles = {"dorwinion_brick_with_moss.png"},
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
	})
end

---------------------------------------------
-------------BLOCKS
---------------------------------------------
minetest.register_node("variety:dorwinion_brick", {
	description = "Dorwninion Brick",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"dorwinion_brick.png"},
	is_ground_content = false,
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = "variety:dorwinion_brick 4",
	recipe = {
		{"variety:dorwinion", "variety:dorwinion"},
		{"variety:dorwinion", "variety:dorwinion"},
	}
})
minetest.register_node("variety:dorwinion_brick_with_flowers", {
	description = "Dorwninion Brick With Flowers",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"dorwinion_brick_with_flowers.png"},
	is_ground_content = false,
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_craft({
	output = "variety:dorwinion_brick_with_flowers 2",
	recipe = {
		{"variety:dorwinion_brick", "flowers:rose"},
		{"variety:dorwinion_brick", "flowers:rose"},
	}
})

minetest.register_node("variety:dorwinion_brick_with_moss", {
	description = "Dorwninion Brick With Moss",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"dorwinion_brick_with_moss.png"},
	is_ground_content = false,
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_craft({
	output = "variety:dorwinion_brick_with_moss 3",
	recipe = {
		{"variety:dorwinion_brick", "bucket:bucket_water"},
		{"variety:dorwinion_brick", "variety:dorwinion_brick"},
	}
})

minetest.register_node("variety:dorwinion_carved", {
	description = "Dorwninion Carved",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"dorwinion_carved.png"},
	is_ground_content = false,
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_craft({
	output = "variety:dorwinion_carved 4",
	recipe = {
		{"variety:dorwinion_brick", "variety:dorwinion_brick_cracked"},
		{"variety:dorwinion_brick_cracked", "variety:dorwinion_brick"},
	}
})

minetest.register_node("variety:dorwinion_brick_cracked", {
	description = "Dorwninion Brick Cracked",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"dorwinion_brick_cracked.png"},
	is_ground_content = false,
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_craft({
	output = "variety:dorwinion_brick_cracked 4",
	recipe = {
		{"variety:dorwinion_brick", "variety:dorwinion_brick"},
		{"variety:dorwinion_brick", "variety:dorwinion_brick"},
	}
})

minetest.register_node("variety:dorwinion", {
	description = "Dorwninion",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"dorwinion.png"},
	is_ground_content = false,
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_node("variety:dorwinion_leaves", {
	description = "Dorwinion Leaves",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"dorwinion_leaves.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{items = {""}, rarity = 20},
			{items = {"variety:dorwinion_leaves"}}
		}
	},
	sounds = default.node_sound_leaves_defaults(),

	after_place_node = after_place_leaves,
})

minetest.register_node("variety:dorwinion_glow_leaves", {
	description = "Dorwinion Glowing Leaves",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"dorwinion_glow_leaves.png"},
	paramtype = "light",
	light_source = 10,    
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{items = {""}, rarity = 20},
			{items = {"variety:dorwinion_glow_leaves"}}
		}
	},
	sounds = default.node_sound_leaves_defaults(),

	after_place_node = after_place_leaves,
})

minetest.register_node("variety:dorwinion_sapling", {
	description = "dorwinion Sapling",
	drawtype = "plantlike",
	tiles = {"dorwinion_trees.png"},
	inventory_image = "dorwinion_trees.png",
	wield_image = "dorwinion_trees.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	on_timer = grow_new_dorwinion_tree,
	selection_box = {
		type = "fixed",
		fixed = {-2 / 16, -0.5, -2 / 16, 2 / 16, 5 / 16, 2 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3, flammable = 2, attached_node = 1, sapling = 1},
	sounds = default.node_sound_leaves_defaults(),

	on_construct = function(pos)
			minetest.get_node_timer(pos):start(math.random(300, 1500))
	end,

	on_place = function(itemstack, placer, pointed_thing)
		itemstack = default.sapling_on_place(itemstack, placer, pointed_thing,
			"variety:dorwinion_sapling",
			{x = -1, y = 0, z = -1}, 
			{x = 1, y = 3, z = 1},
			2 
		)

		return itemstack
	end,
})

local function grow_new_dorwinion_tree(pos)
	if not default.can_grow(pos) then
			minetest.get_node_timer(pos):start(math.random(300, 1500))
		return
	end

	minetest.remove_node(pos)

	local random_tree = "dorwinion_tree_" .. math.random(1, 3) .. ".mts"
	minetest.place_schematic({x = pos.x - 4, y = pos.y, z = pos.z - 4}, minetest.get_modpath("variety") .. "/schematics/" .. random_tree, "0", nil, false)
end


if minetest.get_modpath("bonemeal") ~= nil then
	bonemeal:add_sapling({
		{"variety:dorwinion_sapling", grow_new_dorwinion_tree, "soil"},
	})
end


	default.register_leafdecay({
		trunks = {"default:aspen_tree", "default:tree"},
		leaves = {"variety:dorwinion_leaves", "default:aspen_leaves"},
		radius = 3,
	})
---------------------------------------------
-------------WALLS
---------------------------------------------
if minetest.get_modpath("walls") then

walls.register(":walls:dorwinion_brick", "Dorwinion Brick Wall", "dorwinion_brick.png",
		"variety:dorwinion_brick", default.node_sound_stone_defaults())

walls.register(":walls:dorwinion_carved", "Dorwinion Carved Wall", "dorwinion_carved.png",
		"variety:dorwinion_carved", default.node_sound_stone_defaults())

walls.register(":walls:dorwinion_brick_with_moss", "Dorwinion Brick With Moss Wall", "dorwinion_brick_with_moss.png",
		"variety:dorwinion_brick_with_moss", default.node_sound_stone_defaults())
end

---------------------------------------------
-------------CRAFTS
---------------------------------------------
minetest.register_craft({
	output = "walls:dorwinion_brick 6",
	recipe = {
		{"variety:dorwinion_brick", "variety:dorwinion_brick", "variety:dorwinion_brick"},
		{"variety:dorwinion_brick", "variety:dorwinion_brick", "variety:dorwinion_brick"},
		{"", "", ""},
	}
})

minetest.register_craft({
	output = "walls:dorwinion_carved 6",
	recipe = {
		{"variety:dorwinion_carved", "variety:dorwinion_carved", "variety:dorwinion_carved"},
		{"variety:dorwinion_carved", "variety:dorwinion_carved", "variety:dorwinion_carved"},
		{"", "", ""},
	}
})

minetest.register_craft({
	output = "walls:dorwinion_brick_with_moss 6",
	recipe = {
		{"variety:dorwinion_brick_with_moss", "variety:dorwinion_brick_with_moss", "variety:dorwinion_brick_with_moss"},
		{"variety:dorwinion_brick_with_moss", "variety:dorwinion_brick_with_moss", "variety:dorwinion_brick_with_moss"},
		{"", "", ""},
	}
})


