---------------------------------------------
-------------BLOCKS
---------------------------------------------


minetest.register_node("variety:meadow_tree", {
	description = "Meadow Tree",
	tiles = {"meadow_tree_top.png", "meadow_tree_top.png",
		"meadow_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
	sounds = default.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})


minetest.register_node("variety:meadow_wood", {
	description = "Meadow Wood",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"meadow_wood.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1},
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_node("variety:meadow_leaves", {
	description = "Meadow Leaves",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"meadow_leaves.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{items = {"variety:meadow_sapling"}, rarity = 20},
			{items = {"variety:meadow_leaves"}}
		}
	},
	sounds = default.node_sound_leaves_defaults(),
})

	default.register_leafdecay({
		trunks = {"variety:meadow_tree"},
		leaves = {"variety:meadow_leaves"},
		radius = 3,
	})

	stairs.register_stair_and_slab("meadow_wood", "variety:meadow_wood",
		{choppy = 2, oddly_breakable_by_hand = 2, flammable = 2},
		{"meadow_wood.png"},
		"Meadow Wood Stair",
		"Meadow Wood Slab",
		default.node_sound_wood_defaults())

minetest.register_node("variety:meadow_dirt_with_grass", {
	description = "Meadow Grass",
	tiles = {"meadow_grass.png", "dorwinion.png",
		{name = "dorwinion.png^meadow_grass_side.png",
			tileable_vertical = false}},
	groups = {crumbly = 3, soil = 1, spreading_dirt_type = 1},
	drop = "default:dirt",
	sounds = default.node_sound_dirt_defaults({
		footstep = {name = "default_dirt_footstep", gain = 0.25},
	}),
})

doors.register_fencegate("variety:gate_meadow", {
	description = "Meadow Wood Fence Gate",
	texture = "meadow_wood_fence.png",
	material = "variety:meadow_wood",
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2}
})

	default.register_fence("variety:fence_meadow_wood", {
		description = "Meadow Wood Fence",
		texture = "meadow_wood_fence.png",
		inventory_image = "default_fence_overlay.png^meadow_wood_fence.png^" ..
					"default_fence_overlay.png^[makealpha:255,126,126",
		wield_image = "default_fence_overlay.png^meadow_wood_fence.png^" ..
					"default_fence_overlay.png^[makealpha:255,126,126",
		material = "variety:meadow_wood",
		groups = {choppy = 3, oddly_breakable_by_hand = 2, flammable = 3},
		sounds = default.node_sound_wood_defaults()
	})

	default.register_fence_rail("variety:fence_rail_meadow_wood", {
		description = "Meadow Wood Fence Rail",
		texture = "meadow_wood_fence.png",
		inventory_image = "default_fence_rail_overlay.png^meadow_wood_fence.png^" ..
					"default_fence_rail_overlay.png^[makealpha:255,126,126",
		wield_image = "default_fence_rail_overlay.png^meadow_wood_fence.png^" ..
					"default_fence_rail_overlay.png^[makealpha:255,126,126",
		material = "variety:meadow_wood",
		groups = {choppy = 3, oddly_breakable_by_hand = 2, flammable = 3},
		sounds = default.node_sound_wood_defaults()
	})

minetest.register_node("variety:meadow_sapling", {
	description = "Meadow Sapling",
	drawtype = "plantlike",
	tiles = {"meadow_trees.png"},
	inventory_image = "meadow_trees.png",
	wield_image = "meadow_trees.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	on_timer = grow_new_meadow_tree,
	selection_box = {
		type = "fixed",
		fixed = {-2 / 16, -0.5, -2 / 16, 2 / 16, 5 / 16, 2 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3, flammable = 2, attached_node = 1, sapling = 1},
	sounds = default.node_sound_leaves_defaults(),

	on_construct = function(pos)
			minetest.get_node_timer(pos):start(math.random(300, 1500))
	end,

	on_place = function(itemstack, placer, pointed_thing)
		itemstack = default.sapling_on_place(itemstack, placer, pointed_thing,
			"variety:meadow_sapling",
			{x = -1, y = 0, z = -1}, -- minp, maxp to be checked, relative to sapling pos
			{x = 1, y = 3, z = 1},
			2 -- maximum interval of interior volume check
		)

		return itemstack
	end,
})

local function grow_new_meadow_tree(pos)
	if not default.can_grow(pos) then
		-- Essayer un peu plus tard
			minetest.get_node_timer(pos):start(math.random(300, 1500))
		return
	end

	minetest.remove_node(pos)

	local random_tree = "tree_" .. math.random(1, 2) .. ".mts"
	minetest.place_schematic({x = pos.x - 4, y = pos.y, z = pos.z - 4}, minetest.get_modpath("variety") .. "/schematics/" .. random_tree, "0", nil, false)
end


if minetest.get_modpath("bonemeal") ~= nil then
	bonemeal:add_sapling({
		{"variety:meadow_sapling", grow_new_meadow_tree, "soil"},
	})
end
	default.register_leafdecay({
		trunks = {"variety:meadow_tree"},
		leaves = {"variety:meadow_leaves"},
		radius = 3,
	})

---------------------------------------------
-------------CRAFTS
---------------------------------------------
minetest.register_craft({
	output = "variety:meadow_wood 4",
	recipe = {
		{"variety:meadow_tree"},
	}
})

---------------------------------------------
-------------MOREBLOCKS
---------------------------------------------
if minetest.get_modpath("moreblocks") then

	stairsplus:register_all("meadow_tree", "wood", "variety:meadow_tree", {
		description = "meadow Tree",
	tiles = {"meadow_tree.png"},
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
	})

	stairsplus:register_all("meadow", "wood", "variety:meadow_wood", {
		description = "meadow wood",
	tiles = {"meadow_wood.png"},
	groups = {cracky = 2, flammable = 2, stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
	})
end
