---------------------------------------------
-------------MAPGENS
---------------------------------------------
local localheatpoint = minetest.settings:get("variety_fork.frost_land_heat") or 2
local localhumiditypoint = minetest.settings:get("variety_fork.frost_land_humidity") or 89

	minetest.register_biome({
		name = "frost_land",
        node_dust = "default:snow",
		node_top = "default:dirt_with_snow",
		depth_top = 1,
		node_filler = "default:snowblock",
		depth_filler = 3,
		node_riverbed = "default:snowblock",
		depth_riverbed = 2,
		node_dungeon = "default:ice",
		node_dungeon_alt = "default:snowblock",
		y_max = 31000,
		y_min = 4,
		heat_point = localheatpoint,
		humidity_point = localhumiditypoint,
	})

	minetest.register_biome({
		name = "ice_land",
        node_dust = "default:snow",
		node_top = "default:snowblock",
		depth_top = 4,
		node_filler = "default:ice",
		depth_filler = 250,
		node_riverbed = "default:snowblock",
		depth_riverbed = 2,
		node_dungeon = "default:ice",
		node_dungeon_alt = "default:snowblock",
		y_max = 31000,
		y_min = 1,
		heat_point = 0,
		humidity_point = 100,
	})

minetest.register_decoration({
    name = "variety:frost_tree_1",
    deco_type = "schematic",
    place_on = {"default:dirt_with_snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.001265,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/frost_tree_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:frost_tree_2",
    deco_type = "schematic",
    place_on = {"default:dirt_with_snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.001265,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/frost_tree_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:frost_tree_3",
    deco_type = "schematic",
    place_on = {"default:dirt_with_snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.001265,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/frost_tree_3.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})



minetest.register_decoration({
    name = "variety:ice_1",
    deco_type = "schematic",
    place_on = {"default:dirt_with_snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.002265,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/ice_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:ice_2",
    deco_type = "schematic",
    place_on = {"default:dirt_with_snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.002265,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/ice_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:ice_3",
    deco_type = "schematic",
    place_on = {"default:dirt_with_snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.002265,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/ice_3.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:frost_tree_4",
    deco_type = "schematic",
    place_on = {"default:dirt_with_snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.002265,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/frost_tree_4.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:frost_tree_5",
    deco_type = "schematic",
    place_on = {"default:dirt_with_snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.002265,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/frost_tree_5.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:bush",
    deco_type = "schematic",
    place_on = {"default:snowblock"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.002165,
    biomes = {"frost_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bush.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:ice_1_1",
    deco_type = "schematic",
    place_on = {"default:snowblock", "default:snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.005165,
    biomes = {"ice_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/ice_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})


minetest.register_decoration({
    name = "variety:ice_2_2",
    deco_type = "schematic",
    place_on = {"default:snowblock", "default:snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.005165,
    biomes = {"ice_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/ice_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})


minetest.register_decoration({
    name = "variety:ice_3_3",
    deco_type = "schematic",
    place_on = {"default:snowblock", "default:snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.005165,
    biomes = {"ice_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/ice_3.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:ice_4_4",
    deco_type = "schematic",
    place_on = {"default:snowblock", "default:snow"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.005165,
    biomes = {"ice_land"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/ice_4.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

---------------------------------------------
-------------CREATURA/ANIMALIA
---------------------------------------------
if minetest.get_modpath("creatura") then
creatura.register_abm_spawn("animalia:sheep", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 6,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "frost_land",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})

creatura.register_abm_spawn("animalia:reindeer", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 6,
	max_group = 8,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "frost_land",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:fox", {
	chance = predator_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 1,
	max_group = 2,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "frost_land",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:wolf", {
	chance = predator_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 2,
	max_group = 3,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "frost_land",
	nodes = {"group:soil"},
})
end
