---------------------------------------------
-------------MAPGENS
---------------------------------------------
local localheatpoint = minetest.settings:get("variety_fork.meadow_heat") or 60
local localhumiditypoint = minetest.settings:get("variety_fork.meadow_humidity") or 30

	minetest.register_biome({
		name = "meadow",
		node_top = "variety:meadow_dirt_with_grass",
		depth_top = 1,
        node_filler = "variety:dorwinion",
        depth_filler = 250,
		node_riverbed = "default:sand",
		depth_riverbed = 2,
		node_dungeon = "dorwinion:dorwinion_brick",
		node_dungeon_alt = "dorwinion:dorwinion_brick_with_moss",
		y_max = 31000,
		y_min = 1,
		heat_point = localheatpoint,
		humidity_point = localhumiditypoint,
	})

minetest.register_decoration({
    name = "variety:meadow_rock",
    deco_type = "schematic",
    place_on = {"variety:meadow_dirt_with_grass"},
    place_offset_y = -2,
    sidelen = 16,
    fill_ratio = 0.002265,
    biomes = {"meadow"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/meadow_rock.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:meadow_rock_2",
    deco_type = "schematic",
    place_on = {"variety:meadow_dirt_with_grass"},
    place_offset_y = -2,
    sidelen = 16,
    fill_ratio = 0.000765,
    biomes = {"meadow"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/meadow_rock_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:meadow_tree_1",
    deco_type = "schematic",
    place_on = {"variety:meadow_dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.01565,
    biomes = {"meadow"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/meadow_tree_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})


minetest.register_decoration({
    name = "variety:meadow_tree_2",
    deco_type = "schematic",
    place_on = {"variety:meadow_dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.01565,
    biomes = {"meadow"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/meadow_tree_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})



minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:meadow_dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.06,
	biomes = {"meadow"},
	decoration = {
		"default:grass_1", "default:grass_2",
		"default:grass_3", "default:grass_4",
		"default:grass_5",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:meadow_dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.06,
	biomes = {"meadow"},
	decoration = {
		"flowers:dandelion_white", "flowers:viola",
		"flowers:dandelion_yellow",
		"flowers:chrysanthemum_green",
	}
})

---------------------------------------------
-------------CREATURA/ANIMALIA
---------------------------------------------
if minetest.get_modpath("creatura") then

creatura.register_abm_spawn("animalia:chicken", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 5,
	biomes = chicken_biomes, "meadow",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:cow", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "meadow",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})

creatura.register_abm_spawn("animalia:horse", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "meadow",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})


creatura.register_abm_spawn("animalia:pig", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 2,
	max_group = 3,
	biomes = pig_biomes, "meadow",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:turkey", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "meadow",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:sheep", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 6,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "meadow",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})
end
