---------------------------------------------
-------------MAPGENS
---------------------------------------------
local localheatpoint = minetest.settings:get("variety_fork.redwood_heat") or 60
local localhumiditypoint = minetest.settings:get("variety_fork.redwood_humidity") or 75

minetest.register_biome({
    name = "redwood",
    node_top = "variety:redwood_dirt_with_grass",
    depth_top = 1,
    node_filler = "default:dirt",
    depth_filler = 4,
		node_riverbed = "default:sand",
		depth_riverbed = 3,
		node_dungeon = "default:cobble",
		node_dungeon_alt = "default:mossycobble",
		node_dungeon_stair = "stairs:stair_cobble",
    y_max = 31000,
    y_min = 1,
		heat_point = localheatpoint,
		humidity_point = localhumiditypoint,
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:redwood_dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.05,
	biomes = {"redwood"},
	decoration = {
		"flowers:mushroom_brown",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:redwood_dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.05,
	biomes = {"redwood"},
	decoration = {
          "default:fern_3", "default:fern_2",
 "default:fern_1",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:redwood_dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.02,
	biomes = {"redwood"},
	decoration = {
		"default:junglegrass",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:redwood_dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.02,
	biomes = {"redwood"},
	decoration = {
		"default:dry_shrub",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:redwood_dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.3,
	biomes = {"redwood"},
	decoration = {
		"variety:grass_4", "variety:grass_5",
		"variety:grass_2", "variety:grass_3",
		"variety:grass_1",

	}
})

minetest.register_decoration({
    name = "variety:rock_1",
    deco_type = "schematic",
	place_on = {"variety:redwood_dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.009365,
    biomes = {"redwood"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/rock_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:tree_1",
    deco_type = "schematic",
	place_on = {"variety:redwood_dirt_with_grass"},
    place_offset_y = -2,
    sidelen = 16,
    fill_ratio = 0.009365,
    biomes = {"redwood"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/tree_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:tree_2",
    deco_type = "schematic",
	place_on = {"variety:redwood_dirt_with_grass"},
    place_offset_y = -2,
    sidelen = 16,
    fill_ratio = 0.009365,
    biomes = {"redwood"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/tree_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:tree_3",
    deco_type = "schematic",
	place_on = {"variety:redwood_dirt_with_grass"},
    place_offset_y = -2,
    sidelen = 16,
    fill_ratio = 0.009365,
    biomes = {"redwood"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/tree_3.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:tree_4",
    deco_type = "schematic",
	place_on = {"variety:redwood_dirt_with_grass"},
    place_offset_y = -2,
    sidelen = 16,
    fill_ratio = 0.009365,
    biomes = {"redwood"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/tree_4.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:tree_5",
    deco_type = "schematic",
	place_on = {"variety:redwood_dirt_with_grass"},
    place_offset_y = -2,
    sidelen = 16,
    fill_ratio = 0.009365,
    biomes = {"redwood"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/tree_5.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})



minetest.register_decoration({
    name = "variety:stone",
    deco_type = "schematic",
	place_on = {"variety:redwood_dirt_with_grass"},
    place_offset_y = -1,
    sidelen = 16,
    fill_ratio = 0.000565,
    biomes = {"redwood"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/stone.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:log",
    deco_type = "schematic",
	place_on = {"variety:redwood_dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.009365,
    biomes = {"redwood"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/log.mts",
	flags = "force_placement",
	rotation = "random",
})


---------------------------------------------
-------------CREATURA/ANIMALIA
---------------------------------------------
if minetest.get_modpath("creatura") then

creatura.register_abm_spawn("animalia:reindeer", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 6,
	max_group = 8,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "redwood",
	nodes = {"group:soil"},
})


creatura.register_abm_spawn("animalia:fox", {
	chance = predator_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 1,
	max_group = 2,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "redwood",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:horse", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "redwood",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})



creatura.register_abm_spawn("animalia:turkey", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "redwood",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:wolf", {
	chance = predator_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 2,
	max_group = 3,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "redwood",
	nodes = {"group:soil"},
})
end
