local function grow_new_japanese_tree(pos)
	if not default.can_grow(pos) then
			minetest.get_node_timer(pos):start(math.random(300, 1500))
		return
	end

	minetest.remove_node(pos)

	local random_tree = "japanese_tree_" .. math.random(1, 3) .. ".mts"
	minetest.place_schematic(pos, minetest.get_modpath("variety") .. "/schematics/" .. random_tree, "random", nil, false, "place_center_x, place_center_z")
end


if minetest.get_modpath("bonemeal") then
	bonemeal:add_sapling({
		{"variety:japanese_sapling", grow_new_japanese_tree, "soil"},
	})
end


---------------------------------------------
-------------MOREBLOCKS
---------------------------------------------
if minetest.get_modpath("moreblocks") then

	stairsplus:register_all("japanese_wood", "wood", "variety:japanese_wood", {
		description = "Japanese Wood",
		tiles = {"japanese_wood.png"},
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
	    sounds = default.node_sound_wood_defaults(),
	})

	stairsplus:register_all("tatami_simple", "wood", "variety:tatami_simple", {
		description = "Tatami simple Wood",
		tiles = {"tatami_simple.png"},
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
	    sounds = default.node_sound_wood_defaults(),
	})

	stairsplus:register_all("tatami", "wood", "variety:japanese_tatami", {
		description = "Japanese Tatami",
		tiles = {"tatami.png"},
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
	    sounds = default.node_sound_wood_defaults(),
	})

	stairsplus:register_all("japanese_lamp", "wood", "variety:japanese_lamp", {
		description = "Japanese Lamp",
		tiles = {"japanese_lamp.png"},
	groups = {cracky = 3, oddly_breakable_by_hand = 3},
	    sounds = default.node_sound_glass_defaults(),
	})

	stairsplus:register_all("japanese_tree", "wood", "variety:japanese_tree", {
		description = "japanese Tree",
	tiles = {"japanese_tree_top.png", "japanese_tree_top.png",
		"japanese_tree.png"},
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
	    sounds = default.node_sound_wood_defaults(),
	})
end

---------------------------------------------
-------------BLOCKS
---------------------------------------------
minetest.register_node("variety:japanese_leaves_1", {
	description = "Japanese Leaves Green/Yellow",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"japanese_leaves_1.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{items = {"variety:japanese_sapling"}, rarity = 20},
			{items = {"variety:japanese_leaves_1"}}
		}
	},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node("variety:japanese_leaves_2", {
	description = "Japanese Leaves Dark Green",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"japanese_leaves_2.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{items = {"variety:japanese_sapling"}, rarity = 20},
			{items = {"variety:japanese_leaves_2"}}
		}
	},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node("variety:japanese_leaves_3", {
	description = "Japanese Leaves Green",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"japanese_leaves_3.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{items = {"variety:japanese_sapling"}, rarity = 20},
			{items = {"variety:japanese_leaves_3"}}
		}
	},
	sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node("variety:japanese_tree", {
	description = "Japanese Tree",
	tiles = {"japanese_tree_top.png", "japanese_tree_top.png",
		"japanese_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
	sounds = default.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})

default.register_leafdecay({
	trunks = {"variety:japanese_tree"},
	leaves = {"variety:japanese_leaves_1", "variety:japanese_leaves_2", "variety:japanese_leaves_3"},
	radius = 3,
})



	stairs.register_stair_and_slab("japanese_wood", "variety:japanese_wood",
		{choppy = 2, oddly_breakable_by_hand = 2, flammable = 2},
		{"japanese_wood.png"},
		"japanese Wood Stair",
		"japanese Wood Slab",
		default.node_sound_wood_defaults())


minetest.register_node("variety:japanese_wood", {
	description = "Japanese Wood",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"japanese_wood.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1},
	sounds = default.node_sound_wood_defaults(),
})


minetest.register_node("variety:tatami_simple", {
	description = "Japanese Simple Tatami",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"tatami_simple.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1},
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_node("variety:japanese_tatami", {
	description = "Japanese Tatami",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"tatami.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1},
	sounds = default.node_sound_wood_defaults(),
})

doors.register_trapdoor("variety:japanese_trapdoor", {
	description = "Japanese Trapdoor",
	inventory_image = "japanese_trapdoor.png",
	wield_image = "japanese_trapdoor.png",
	tile_front = "japanese_trapdoor.png",
	tile_side = "japanese_trapdoor_side.png",
	gain_open = 0.06,
	gain_close = 0.13,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, door = 1},
})


doors.register("japanese_door", {
		tiles = {{ name = "doors_japanese_door.png", backface_culling = true }},
		description = "Japanese Door",
		inventory_image = "doors_item_japanese.png",
		groups = {node = 1, choppy = 2, oddly_breakable_by_hand = 2, flammable = 2},
		gain_open = 0.06,
		gain_close = 0.13,
		recipe = {
			{"bambooforest:fiber_bamboo", "variety:japanese_wood"},
			{"variety:japanese_wood", "bambooforest:fiber_bamboo"},
			{"bambooforest:fiber_bamboo", "variety:japanese_wood"},
		}
})

xpanes.register_pane("variety:japanese_small_wall_flat", {
	description = "Japanese Small Wall",
	textures = {"small_wall.png", "", "side_small_wall.png"},
	inventory_image = "small_wall.png",
	wield_image = "small_wall.png",
	sounds = default.node_sound_wood_defaults(),
	groups = {choppy=1, oddly_breakable_by_hand=2, flammable = 3},
	recipe = {
		{"bambooforest:fiber_bamboo", "bambooforest:fiber_bamboo", "bambooforest:fiber_bamboo"},
		{"dye:magenta", "variety:japanese_wood", "dye:magenta"},
	}
})

doors.register_fencegate("variety:gate_japanese", {
	description = "Japanese Wood Fence Gate",
	texture = "japanese_wood_fence.png",
	material = "variety:japanese_wood",
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2}
})

	default.register_fence("variety:fence_japanese_wood", {
		description = "Japanese Wood Fence",
		texture = "japanese_wood_fence.png",
		inventory_image = "japaneseforest_fence_overlay.png^japanese_wood_fence.png^" ..
					"japaneseforest_fence_overlay.png^[makealpha:255,126,126",
		wield_image = "japaneseforest_fence_overlay.png^japanese_wood_fence.png^" ..
					"japaneseforest_fence_overlay.png^[makealpha:255,126,126",
		material = "variety:japanese_wood",
		groups = {choppy = 3, oddly_breakable_by_hand = 2, flammable = 3},
		sounds = default.node_sound_wood_defaults()
	})

	default.register_fence_rail("variety:fence_rail_japanese_wood", {
		description = "Japanese Wood Fence Rail",
		texture = "japanese_wood_fence.png",
		inventory_image = "japaneseforest_fence_rail_overlay.png^japanese_wood_fence.png^" ..
					"japaneseforest_fence_rail_overlay.png^[makealpha:255,126,126",
		wield_image = "japaneseforest_fence_rail_overlay.png^japanese_wood_fence.png^" ..
					"japaneseforest_fence_rail_overlay.png^[makealpha:255,126,126",
		material = "variety:japanese_wood",
		groups = {choppy = 3, oddly_breakable_by_hand = 2, flammable = 3},
		sounds = default.node_sound_wood_defaults()
	})

minetest.register_node("variety:japanese_dirt_with_grass", {
	description = "Japanese Dirt With Grass",
	tiles = {"japaneseforest_japanese_grass.png", "default_dirt.png",
		{name = "default_dirt.png^japaneseforest_japanese_grass_side.png",
			tileable_vertical = false}},
	groups = {crumbly = 3, soil = 1, spreading_dirt_type = 1},
	drop = "default:dirt",
	sounds = default.node_sound_dirt_defaults({
		footstep = {name = "default_grass_footstep", gain = 0.25},
	}),
})

minetest.register_node("variety:japanese_lamp", {
	description = "Japanese Lamp",
	drawtype = "glasslike",
	tiles = {"japanese_lamp.png"},
	paramtype = "light",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {cracky = 3, oddly_breakable_by_hand = 3},
	sounds = default.node_sound_wood_defaults(),
	light_source = default.LIGHT_MAX,
})

minetest.register_node("variety:japanese_sapling", {
	description = "Japanese Sapling",
	drawtype = "plantlike",
	tiles = {"japanese_sapling.png"},
	inventory_image = "japanese_sapling.png",
	wield_image = "japanese_sapling.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	on_timer = grow_new_japanese_tree,
	selection_box = {
		type = "fixed",
		fixed = {-2 / 16, -0.5, -2 / 16, 2 / 16, 5 / 16, 2 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3, flammable = 2, attached_node = 1, sapling = 1},
	sounds = default.node_sound_leaves_defaults(),

	on_construct = function(pos)
			minetest.get_node_timer(pos):start(math.random(300, 1500))
	end,

	on_place = function(itemstack, placer, pointed_thing)
		itemstack = default.sapling_on_place(itemstack, placer, pointed_thing,
			"variety:japanese_sapling",
			{x = -1, y = 0, z = -1}, 
			{x = 1, y = 3, z = 1},
			2 
		)

		return itemstack
	end,
})


