---------------------------------------------
-------------MAPGENS
---------------------------------------------

local localheatpoint = minetest.settings:get("variety_fork.bamboo_forest_heat") or 89
local localhumiditypoint = minetest.settings:get("variety_fork.bamboo_forest_humidity") or 77

minetest.register_biome({
    name = "bamboo_forest",
    node_top = "variety:dirt_with_bamboo",
    depth_top = 1,
    node_filler = "default:dirt",
    depth_filler = 3,
		node_riverbed = "default:sand",
		depth_riverbed = 3,
		node_dungeon = "default:cobble",
		node_dungeon_alt = "default:mossycobble",
		node_dungeon_stair = "stairs:stair_cobble",
    y_max = 31000,
    y_min = 5,
    heat_point = localheatpoint,
    humidity_point = localhumiditypoint,
})

------------Shematics
minetest.register_decoration({
    name = "variety:bamboo_tree_1",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.012565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bamboo_tree_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:bamboo_tree_2",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.012565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bamboo_tree_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:bamboo_tree_3",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.012565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bamboo_tree_3.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:bamboo_tree_4",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.012565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bamboo_tree_4.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:bamboo_tree_5",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.012565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bamboo_tree_5.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:bamboo_tree_5",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.015565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bamboo_tree_5.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:bamboo_tree_6",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.012565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bamboo_tree_6.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:bamboo_tree_7",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.012565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("variety").."/schematics/bamboo_tree_7.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})



minetest.register_decoration({
    name = "variety:granite_boulder",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = -2,
    sidelen = 16,
    fill_ratio = 0.002035,
    biomes = {"bamboo_forest"},
    y_max = 30,
    y_min = 0,
    schematic = minetest.get_modpath("variety").."/schematics/granite_boulder.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:jungle_tree",
    deco_type = "schematic",
    place_on = {"variety:dirt_with_bamboo"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.007565,
    biomes = {"bamboo_forest"},
    y_max = 31000,
    y_min = -20,
    schematic = minetest.get_modpath("default").."/schematics/jungle_tree.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})



--------------Decoration (node)
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:dirt_with_bamboo"},
	sidelen = 16,
	fill_ratio = 0.1,
	biomes = {"bamboo_forest"},
	decoration = {
		"default:junglegrass"
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:dirt_with_bamboo"},
	sidelen = 16,
	fill_ratio = 0.05,
	biomes = {"bamboo_forest"},
	decoration = {
		"flowers:mushroom_brown", "flowers:mushroom_red"
	}
})



minetest.register_decoration({
	deco_type = "simple",
	place_on = {"variety:dirt_with_bamboo"},
	sidelen = 16,
	fill_ratio = 0.2,
	biomes = {"bamboo_forest"},
	decoration = {
		"default:grass_1", "default:grass_2",
		"default:grass_3", "default:grass_4",
		"default:grass_5",
	}
})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "variety:granite",
		wherein         = {"default:stone"},
		clust_scarcity  = 16 * 16 * 16,
		clust_size      = 5,
		y_max           = -50,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 766,
			octaves = 1,
			persist = 0.0
		},
	})


---------------------------------------------
-------------CREATURA/ANIMALIA
---------------------------------------------

if minetest.get_modpath("creatura") then
creatura.register_abm_spawn("animalia:sheep", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 6,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "bamboo_forest",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})

creatura.register_abm_spawn("animalia:reindeer", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 6,
	max_group = 8,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "bamboo_forest",
	nodes = {"group:soil"},
})


creatura.register_abm_spawn("animalia:fox", {
	chance = predator_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 1,
	max_group = 2,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "bamboo_forest",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:chicken", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 5,
	biomes = chicken_biomes, "bamboo_forest",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:pig", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 2,
	max_group = 3,
	biomes = pig_biomes, "bamboo_forest",
	nodes = {"group:soil"},
})
end



