---------------------------------------------
-------------MAPGENS
---------------------------------------------
local localheatpoint = minetest.settings:get("variety_fork.dorwinion_heat") or 38
local localhumiditypoint = minetest.settings:get("variety_fork.dorwinion_humidity") or 38

	minetest.register_biome({
		name = "dorwinion",
		node_top = "default:dirt_with_grass",
		depth_top = 1,
        node_filler = "default:dirt",
        depth_filler = 3,
        node_stone = "variety:dorwinion",
		node_riverbed = "default:sand",
		depth_riverbed = 2,
		node_dungeon = "variety:dorwinion_brick",
		node_dungeon_alt = "variety:dorwinion_brick_with_moss",
		y_max = 31000,
		y_min = 4,
		heat_point = localheatpoint,
		humidity_point = localhumiditypoint,
	})

minetest.register_decoration({
    name = "variety:dorwinion_tree_1",
    deco_type = "schematic",
    place_on = {"default:dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.006265,
    biomes = {"dorwinion"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/dorwinion_tree_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:dorwinion_tree_2",
    deco_type = "schematic",
    place_on = {"default:dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.006265,
    biomes = {"dorwinion"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/dorwinion_tree_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})



minetest.register_decoration({
    name = "variety:bush_1",
    deco_type = "schematic",
    place_on = {"default:dirt_with_grass"},
    place_offset_y = 1,
    sidelen = 16,
    fill_ratio = 0.015265,
    biomes = {"dorwinion"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/bush_1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:dorwinion_tree_3",
    deco_type = "schematic",
    place_on = {"default:dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.006265,
    biomes = {"dorwinion"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/dorwinion_tree_3.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
    name = "variety:dorwinion_tree_4",
    deco_type = "schematic",
    place_on = {"default:dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.006265,
    biomes = {"dorwinion"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("variety").."/schematics/dorwinion_tree_4.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})


minetest.register_decoration({
    name = "variety:aspen_tree",
    deco_type = "schematic",
    place_on = {"default:dirt_with_grass"},
    place_offset_y = 0,
    sidelen = 16,
    fill_ratio = 0.002265,
    biomes = {"dorwinion"},
    y_max = 31000,
    y_min = 1,
    schematic = minetest.get_modpath("default").."/schematics/aspen_tree.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random",
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.3,
	biomes = {"dorwinion"},
	decoration = {
		"default:grass_1", "default:grass_2",
		"default:grass_3", "default:grass_4",
		"default:grass_5",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.05,
	biomes = {"dorwinion"},
	decoration = {
		"flowers:rose", "flowers:dandelion_yellow",
		"flowers:dandelion_white", "flowers:chryssanthemum_green",
		"flowers:mushroom_brown",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.01,
	biomes = {"dorwinion"},
	decoration = {
		"flowers:mushroom_brown",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.08,
	biomes = {"dorwinion"},
	decoration = {
		"variety:dorwinion_leaves",
	}
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.05,
	biomes = {"dorwinion"},
	decoration = {
"butterflies:butterfly_white", "butterflies:butterfly_red", "butterflies:butterfly_violet",
	}
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_grass", "variety:dorwinion_leaves"},
	sidelen = 16,
	fill_ratio = 0.02,
	biomes = {"dorwinion"},
	decoration = {
"variety:dorwinion_glow_leaves",
	}
})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "variety:dorwinion",
		wherein         = {"default:dirt"},
		clust_scarcity  = 16 * 16 * 16,
		clust_size      = 5,
		y_max           = -50,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
	        biomes = {"dorwinion"},
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 766,
			octaves = 1,
			persist = 0.0
		},
	}) 


---------------------------------------------
-------------CREATURA/ANIMALIA
---------------------------------------------
if minetest.get_modpath("creatura") then
creatura.register_abm_spawn("animalia:sheep", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 6,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "dorwinion",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})

creatura.register_abm_spawn("animalia:reindeer", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 6,
	max_group = 8,
	biomes = animalia.registered_biome_groups["boreal"].biomes, "dorwinion",
	nodes = {"group:soil"},
})

creatura.register_abm_spawn("animalia:horse", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "dorwinion",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})

creatura.register_abm_spawn("animalia:cow", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 4,
	biomes = animalia.registered_biome_groups["grassland"].biomes, "dorwinion",
	nodes = {"group:soil"},
	neighbors = {"air", "group:grass", "group:flora"}
})

creatura.register_abm_spawn("animalia:chicken", {
	chance = common_spawn_chance,
	min_height = 0,
	max_height = 1024,
	min_group = 3,
	max_group = 5,
	biomes = chicken_biomes, "dorwinion",
	nodes = {"group:soil"},
})
end
