
-- check for available hunger mods
local hmod = minetest.global_exists("hunger")
local hbmod = minetest.global_exists("hbhunger")
local stmod = minetest.global_exists("stamina")

local screwdriver_exists = minetest.global_exists("screwdriver")

-- eat pie slice function
local function replace_pie(node, puncher, pos)

	-- is this my pie?
	if minetest.is_protected(pos, puncher:get_player_name()) then
		return
	end

	-- which size of pie did we hit?
	local pie = node.name:split("_")[1]
	local num = tonumber(node.name:split("_")[2])

	-- are we using crystal shovel to pick up full pie using soft touch?
	local tool = puncher:get_wielded_item():get_name()
	if num == 0 and tool == "ethereal:shovel_crystal" then

		local inv = puncher:get_inventory()

		minetest.remove_node(pos)

		if inv:room_for_item("main", {name = pie .. "_0"}) then
			inv:add_item("main", pie .. "_0")
		else
			pos.y = pos.y + 0.5
			minetest.add_item(pos, {name = pie .. "_0"})
		end

		return
	end

	-- eat slice or remove whole pie
	if num == 3 then
		node.name = "air"
	elseif num < 3 then
		node.name = pie .. "_" .. (num + 1)
	end

	minetest.swap_node(pos, node)

	if num == 3 then
		minetest.check_for_falling(pos)
	end

	-- Blockmen's hud_hunger mod
	if hmod then

		local h = hunger.read(puncher)
--		print ("hunger is "..h)

		h = math.min(h + 4, 30)

		local ok = hunger.update_hunger(puncher, h)

		minetest.sound_play("hunger_eat", {
			pos = pos, gain = 0.7, max_hear_distance = 5})

	-- Wuzzy's hbhunger mod
	elseif hbmod then

		local h = tonumber(hbhunger.hunger[puncher:get_player_name()])
--		print ("hbhunger is "..h)

		h = math.min(h + 4, 30)

		hbhunger.hunger[puncher:get_player_name()] = h

		minetest.sound_play("hbhunger_eat_generic", {
			pos = pos, gain = 0.7, max_hear_distance = 5})

	-- Sofar's stamina mod
	elseif stmod then

		stamina.change(puncher, 4)

		minetest.sound_play("stamina_eat", {
			pos = pos, gain = 0.7, max_hear_distance = 5})

	-- none of the above found? add to health instead
	else

		local h = puncher:get_hp()
--		print ("health is "..h)

		h = math.min(h + 4, 20)

		puncher:set_hp(h)
	end
end


-- register pie bits
local function register_pie(pie, desc)

	-- full pie
	minetest.register_node("pie:" .. pie .. "_0", {
		description = desc,
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = "clip",
		sunlight_propagates = false,
		tiles = {
			pie .. "_top.png", pie .. "_bottom.png", pie .. "_side.png",
			pie .. "_side.png", pie .. "_side.png", pie .. "_side.png"
		},
		inventory_image = pie .. "_inv.png",
		wield_image = pie .. "_inv.png",
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {-0.45, -0.5, -0.45, 0.45, 0, 0.45}
		},

		on_rotate = screwdriver_exists and screwdriver.rotate_simple,

		on_punch = function(pos, node, puncher, pointed_thing)
			replace_pie(node, puncher, pos)
		end
	})

	-- 3/4 pie
	minetest.register_node("pie:" .. pie .. "_1", {
		description = "3/4 " .. desc,
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = "clip",
		sunlight_propagates = true,
		tiles = {
			pie .. "_top.png", pie .. "_bottom.png", pie .. "_side.png",
			pie .. "_side.png", pie .. "_side.png", pie .. "_inside.png"
		},
		groups = {not_in_creative_inventory = 1},
		drop = {},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {-0.45, -0.5, -0.25, 0.45, 0, 0.45}
		},

		on_rotate = screwdriver_exists and screwdriver.rotate_simple,

		on_punch = function(pos, node, puncher, pointed_thing)
			replace_pie(node, puncher, pos)
		end
	})

	-- 1/2 pie
	minetest.register_node("pie:" .. pie .. "_2", {
		description = "Half " .. desc,
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = "clip",
		sunlight_propagates = true,
		tiles = {
			pie .. "_top.png", pie .. "_bottom.png", pie .. "_side.png",
			pie .. "_side.png", pie .. "_side.png", pie .. "_inside.png"
		},
		groups = {not_in_creative_inventory = 1},
		drop = {},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {-0.45, -0.5, 0.0, 0.45, 0, 0.45}
		},

		on_rotate = screwdriver_exists and screwdriver.rotate_simple,

		on_punch = function(pos, node, puncher, pointed_thing)
			replace_pie(node, puncher, pos)
		end
	})

	-- 1/4 pie
	minetest.register_node("pie:" .. pie .. "_3", {
		description = "Piece of " .. desc,
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = "clip",
		sunlight_propagates = true,
		tiles = {
			pie .. "_top.png", pie .. "_bottom.png", pie .. "_side.png",
			pie .. "_side.png", pie .. "_side.png", pie .. "_inside.png"
		},
		groups = {not_in_creative_inventory = 1},
		drop = {},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {-0.45, -0.5, 0.25, 0.45, 0, 0.45}
		},

		on_rotate = screwdriver_exists and screwdriver.rotate_simple,

		on_punch = function(pos, node, puncher, pointed_thing)
			replace_pie(node, puncher, pos)
		end
	})
end


-- normal cake
register_pie("pie", "Cake")

minetest.register_craft({
	output = "pie:pie_0",
	recipe = {
		{"group:food_sugar", "group:food_milk", "group:food_sugar"},
		{"group:food_sugar", "group:food_egg", "group:food_sugar"},
		{"group:food_wheat", "group:food_flour", "group:food_wheat"}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})


-- chocolate cake
register_pie("choc", "Chocolate Cake")

minetest.register_craft({
	output = "pie:choc_0",
	recipe = {
		{"group:food_cocoa", "group:food_milk", "group:food_cocoa"},
		{"group:food_sugar", "group:food_egg", "group:food_sugar"},
		{"group:food_wheat", "group:food_flour", "group:food_wheat"}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})


-- strawberry cheesecake
register_pie("scsk", "Strawberry Cheesecake")

minetest.register_craft({
	output = "pie:scsk_0",
	recipe = {
		{"group:food_strawberry", "group:food_milk", "group:food_strawberry"},
		{"group:food_sugar", "group:food_egg", "group:food_sugar"},
		{"group:food_wheat", "group:food_flour", "group:food_wheat"}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})


-- coffee cake
register_pie("coff", "Coffee Cake")

minetest.register_craft({
	output = "pie:coff_0",
	recipe = {
		{"group:food_coffee", "group:food_milk", "group:food_coffee"},
		{"group:food_sugar", "group:food_egg", "group:food_sugar"},
		{"group:food_wheat", "group:food_flour", "group:food_wheat"}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})


-- red velvet cake
register_pie("rvel", "Red Velvet Cake")

minetest.register_craft({
	output = "pie:rvel_0",
	recipe = {
		{"group:food_cocoa", "group:food_milk", "dye:red"},
		{"group:food_sugar", "group:food_egg", "group:food_sugar"},
		{"group:food_flour", "group:food_cheese", "group:food_flour"}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})


-- meat cake
register_pie("meat", "Meat Cake")

minetest.register_craft({
	output = "pie:meat_0",
	recipe = {
		{"group:food_meat_raw", "group:food_egg", "group:food_meat_raw"},
		{"group:food_wheat", "group:food_wheat", "group:food_wheat"}
	}
})


-- banana cake
register_pie("bana", "Banana Cake")

minetest.register_craft({
	output = "pie:bana_0",
	recipe = {
		{"group:food_banana", "group:food_milk", "group:food_banana"},
		{"group:food_sugar", "group:food_egg", "group:food_sugar"},
		{"group:food_wheat", "group:food_flour", "group:food_wheat"}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})


-- bread pudding
register_pie("brpd", "Bread Pudding")

minetest.register_craft({
	output = "pie:brpd_0",
	recipe = {
		{"group:food_bread", "group:food_milk", "group:food_bread"},
		{"group:food_sugar", "group:food_egg", "group:food_sugar"},
		{"group:food_wheat", "group:food_flour", "group:food_wheat"}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})


-- orange pie
register_pie("orange", "Orange Pie")

minetest.register_craft({
	output = "pie:orange_0",
	recipe = {
		{"group:food_orange", "group:food_milk", "group:food_orange"},
		{"group:food_sugar", "group:food_egg", "group:food_sugar"},
		{"group:food_wheat", "group:food_flour", "group:food_wheat"}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})


-- add lucky blocks
if minetest.get_modpath("lucky_block") then
lucky_block:add_blocks({
	{"nod", "pie:pie_0", 0},
	{"nod", "pie:choc_0", 0},
	{"nod", "pie:coff_0", 0},
	{"tro", "pie:pie_0"},
	{"nod", "pie:rvel_0", 0},
	{"nod", "pie:scsk_0", 0},
	{"nod", "pie:bana_0", 0},
	{"nod", "pie:orange_0", 0},
	{"tro", "pie:orange_0", "default_place_node_hard", true},
	{"nod", "pie:brpd_0", 0},
	{"nod", "pie:meat_0", 0},
	{"lig"}
})
end


-- some aliases for older pie mod by Mitroman
minetest.register_alias("pie:apie_0", "pie:pie_0")
minetest.register_alias("pie:apie_1", "pie:pie_1")
minetest.register_alias("pie:apie_2", "pie:pie_2")
minetest.register_alias("pie:apie_3", "pie:pie_3")
minetest.register_alias("pie:piebatter", "pie:pie_0")
minetest.register_alias("pie:apiebatter", "pie:pie_0")
minetest.register_alias("pie:amuffinbatter", "pie:pie_0")
minetest.register_alias("pie:applemuffin", "pie:pie_0")
minetest.register_alias("pie:sugar", "farming:sugar")
minetest.register_alias("pie:knife", "default:sword_steel")


print("[MOD] Pie loaded")
