<p align="center">
   <img src="https://i.imgur.com/uh8Ee9T.jpg"/>
</p>

# Hallelujah Mountains for Minetest

<img src="https://raw.githubusercontent.com/wiki/treer/amidstest/screenshots/150px-Minetest-logo.png" align="right" />

[![License](https://img.shields.io/badge/license-LGPLv2.1%2B-blue.svg)](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html)

AKA Cloudlands — giant rocks floating suspended in magnetic eddies. Now with giant trees

This can be run with or without a normal terrain mapgen, allowing pure skylands or an exotic addition to the landscape.

Many Configurable settings, including the altitude islands appear, and the ability to restrict the areas they spawn.

It's a single file with no hard dependencies for easy integration into modpacks or games, e.g. as an exotic biome. 

Hallelujah Mountains [maps](https://i.imgur.com/2SkoAyB.png) can be generated by [Amidstest](https://forum.minetest.net/viewtopic.php?t=19869), provided you know the seed of the world. The islands are not homogenous — there will be areas without any, while smaller islands tend to follow eddy fields, often emanating out from much larger and rarer islands.

**Mod dependencies:** None.

**Minetest version:** v5.0+

**Recommended mods:**
* [Vines](https://forum.minetest.net/viewtopic.php?t=2344), or something that contains vines, such as plantlife_modpack or MineClone2. These will grow off the sides of the islands, climate permitting, allowing you to climb, and looking picturesque!
* [Nether](https://forum.minetest.net/viewtopic.php?t=5790) enables players to build portals to Hallelujah Mountains, allowing secret entrances into floating kingdoms, or the island altitude to be configured way up high while still having a means to get there. Stones to build these portals can only be found in the Nether.
* Extra ways to explore
    * [Bridger](https://forum.minetest.net/viewtopic.php?t=18243) or [Bridges](https://forum.minetest.net/viewtopic.php?t=3488) if you want to build nice wooden bridges between islands
    * [Airboat](https://github.com/paramat/airboat) to sail the high clouds on a small airship
    * [Flying carpet](https://forum.minetest.net/viewtopic.php?t=12263)
    * [Jetpack, wings, etc.](https://forum.minetest.net/viewtopic.php?t=11257)
    * [Hang-glider / Elytra](https://forum.minetest.net/viewtopic.php?t=21425)
    * Teleporter mods, balloon mods, etc.

**Ores tip:** If you decide ores like iron and diamond should be obtainable from island stone, and are playing Minetest Game, you can go into Settings->Advanced Settings->Mods->cloudlands, set the "Altitude of Islands" to be 1300 (or higher), and Enable "Generate ores inside islands". This works because Minetest Game also generates the deep-underground ores in stone above 1025 to ensure they can be found in mgV7 Floatlands. Ores can be added in other games or at other altitudes by adding adjusted copies of the game's calls to minetest.register_ore().

**Video:** [Minetest Mod Review: Cloudlands](http://www.nathansalapat.com/minetest/cloudlands)

**Forum:** [link](https://forum.minetest.net/viewtopic.php?t=20257)

**Screenshots:**
  
[![default](https://i.imgur.com/jwHN6Sd.jpg)](http://panoramas.minetest.land/IslandMoonlight.html)

![default](https://i.imgur.com/PUjjaIK.jpg)

![default](https://i.imgur.com/xn9UING.jpg)

![default](https://i.imgur.com/SeYMfZv.jpg)

![default](https://i.imgur.com/wBLEFWn.jpg)

![default](https://i.imgur.com/A6vDDGc.jpg)


