
local S = minetest.get_translator("mobs_monster")

-- custom particle effects

local function effect(pos, amount, texture, min_size, max_size, radius, gravity, glow)

	radius = radius or 2
	min_size = min_size or 0.5
	max_size = max_size or 1
	gravity = gravity or -10
	glow = glow or 0

	minetest.add_particlespawner({
		amount = amount,
		time = 0.25,
		minpos = pos,
		maxpos = pos,
		minvel = {x = -radius, y = -radius, z = -radius},
		maxvel = {x = radius, y = radius, z = radius},
		minacc = {x = 0, y = gravity, z = 0},
		maxacc = {x = -20, y = gravity, z = 15},
		minexptime = 0.1,
		maxexptime = 1,
		minsize = min_size,
		maxsize = max_size,
		texture = texture,
		glow = glow
	})
end

-- Sand Monster by PilzAdam

mobs:register_mob("mobs_monster:sand_monster", {
	type = "monster",
	passive = false,
	attack_type = "dogfight",
	pathfinding = true,
	--specific_attack = {"player", "mobs_npc:npc"},
	--ignore_invisibility = true,
	reach = 2,
	damage = 1,
	hp_min = 4,
	hp_max = 20,
	armor = 100,
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	visual = "mesh",
	mesh = "mobs_sand_monster.b3d",
	textures = {
		{"mobs_sand_monster.png"},
		{"mobs_sand_monster2.png"}
	},
	blood_texture = "default_desert_sand.png",
	makes_footstep_sound = true,
	sounds = {random = "mobs_sandmonster"},
	walk_velocity = 1.5,
	run_velocity = 4,
	view_range = 8,
	jump = true,
	floats = 0,
	drops = {
		{name = "default:silver_sand", chance = 2, min = 1, max = 2},
		{name = "default:desert_sand", chance = 2, min = 1, max = 2},
		{name = "default:sand", chance = 2, min = 1, max = 2},
		{name = "default:clay_lump", chance = 2, min = 0, max = 1}
	},
	water_damage = 3,
	lava_damage = 4,
	light_damage = 0,
	fear_height = 4,
	animation = {
		speed_normal = 15, speed_run = 15,
		stand_start = 0, stand_end = 39,
		walk_start = 41, walk_end = 72,
		run_start = 74, run_end = 105,
		punch_start = 74, punch_end = 105
	},
	immune_to = {
		{"default:shovel_wood", 3}, -- shovels deal more damage to sand monster
		{"default:shovel_stone", 3},
		{"default:shovel_bronze", 4},
		{"default:shovel_steel", 4},
		{"default:shovel_mese", 5},
		{"default:shovel_diamond", 7}
	},
--[[
	custom_attack = function(self, p)
		local pos = self.object:get_pos()
		minetest.add_item(pos, "default:sand")
	end,
]]
	on_die = function(self, pos)
		pos.y = pos.y + 0.5
		mobs:effect(pos, 30, "mobs_sand_particles.png", .1, 2, 3, 5)
		pos.y = pos.y + 0.25
		mobs:effect(pos, 30, "mobs_sand_particles.png", .1, 2, 3, 5)
	end,
--[[
	on_rightclick = function(self, clicker)

		local tool = clicker:get_wielded_item()
		local name = clicker:get_player_name()

		if tool:get_name() == "default:sand" then

			self.owner = name
			self.type = "npc"

			mobs:force_capture(self, clicker)
		end
	end,
]]
})

-- where to spawn

if not mobs.custom_spawn_monster then

	mobs:spawn({
		name = "mobs_monster:sand_monster",
		nodes = {"default:desert_sand"},
		chance = 7000,
		active_object_count = 2,
		min_height = 0
	})
end

-- spawn egg

mobs:register_egg("mobs_monster:sand_monster", S("Sand Monster"),
		"default_desert_sand.png", 1)

-- compatibility with older mobs mod

mobs:alias_mob("mobs:sand_monster", "mobs_monster:sand_monster")
