local vedbo_nodebox = {
	type = "fixed",
	fixed = {
		{-7 / 16, -8 / 16, -7 / 16, 7 / 16, 2 / 16, 7 / 16}, -- Bottom
		{-7 / 16, 2 / 16, 6 / 16, 7 / 16, 16 / 16, 7 / 16}, -- Back
		{-7 / 16, 2 / 16, -7 / 16, -5 / 16, 4 / 16, 6 / 16}, -- Right Armrest
		{5 / 16, 2 / 16, -7 / 16, 7 / 16, 4 / 16, 6 / 16}, -- Left Armrest
	},
}

local vedbo_def = ikea.default_furniture_def()
vedbo_def.description = "Vedbo Chair (Pink)"
vedbo_def.mesh = "ikea_chairs_vedbo.obj"
vedbo_def.tiles = {"ikea_chairs_vedbo.png"}
vedbo_def.groups.chair = 1
vedbo_def.groups.lounge = 1
vedbo_def.box_contents = {
	"ikea:furniture_leg",
	"ikea:furniture_leg",
	"ikea:furniture_leg",
	"ikea:furniture_leg",
	"ikea:furniture_board",
	"ikea:furniture_board",
}
vedbo_def.selection_box = vedbo_nodebox
vedbo_def.collision_box = vedbo_nodebox
vedbo_def.tool_capabilities = {full_punch_interval = 4, damage_groups = {fleshy = 10}}

minetest.register_node(":chairs:vedbo", vedbo_def)

local svenbertil_box = {
	type = "fixed",
	fixed = {
		{-0.437484, 0.937491, 0.313884, 0.437516, 0.124991, 0.376384}, -- Back
		{-0.437484, 0.124991, -0.436116, 0.437516, 0.062491, 0.376384}, -- Seat
		{-0.374984, 0.062491, -0.373616, -0.312484, -0.500009, 0.313884}, -- Left
		{0.312516, 0.062491, -0.373616, 0.375016, -0.500009, 0.313884}, -- Right
	},
}

local svenbertil_def = ikea.default_furniture_def()
svenbertil_def.description = "Svenbertil Chair"
svenbertil_def.mesh = "ikea_chairs_svenbertil.obj"
svenbertil_def.tiles = {"ikea_chairs_svenbertil.png"}
svenbertil_def.selection_box = svenbertil_box
svenbertil_def.collision_box = svenbertil_box
svenbertil_def.groups.chair = 1
svenbertil_def.groups.kitchen = 1
svenbertil_def.box_contents = {
	"ikea:furniture_leg",
	"ikea:furniture_leg",
	"ikea:furniture_leg",
	"ikea:furniture_leg",
	"ikea:furniture_board",
	"ikea:furniture_board",
}
svenbertil_def.tool_capabilities = {full_punch_interval = 4, damage_groups = {fleshy = 10}}

minetest.register_node(":chairs:svenbertil", svenbertil_def)
