local function half_equals(t1, t2)
	for k, v in pairs(t1) do
		if t2[k] == nil then
			return false
		elseif type(v) == "table" then
			if (v ~= t1) and (not half_equals(t2[k], v)) then
				return false
			end
		elseif not (t2[k] == v) then
			return false
		end
	end
	return true
end

function table.equals(t1, t2)
	return half_equals(t1, t2) and half_equals(t2, t1)
end

function table.merge(t1, t2)
	for k, v in pairs(t2) do
		t1[k] = v
	end
end
