minetest.register_on_mods_loaded(function()
	for name, def in pairs(minetest.registered_nodes) do
		local breakable = minetest.get_item_group(name, "breakable")
		if breakable > 0 then
			local old_preverve_metadata = def.preserve_metadata
			def.preserve_metadata = function(pos, oldnode, oldmeta, drops)
				old_preverve_metadata(pos, oldnode, oldmeta, drops)
				drops[1]:get_meta():set_int("hp", oldmeta.hp or breakable)
			end

			local old_after_place_node = def.after_place_node
			def.after_place_node = function(pos, placer, itemstack, pointed_thing)
				old_after_place_node(pos, placer, itemstack, pointed_thing)
				minetest.get_meta(pos):set_int("hp", itemstack:get_meta():get_int("hp") or breakable)
				return false
			end

			function def.damage(pos, direction, damage)
				local meta = minetest.get_meta(pos)
				local hp = meta and meta:get_int("hp") or breakable
				hp = hp - (damage or 1)
				meta:set_int("hp", hp)

				if hp <= 0 then
					minetest.set_node(pos, {name = "air"})
					for _, item in pairs(minetest.registered_nodes[node.name].box_contents or {}) do
						local vel = vector.multiply(direction, math.random(3, 5))
						minetest.add_item(pos, item):set_velocity(vel)
					end
				end
			end
		end
	end
end)
