local helpers = {}

function helpers.randompos(pos, radius)
	local t = 2 * math.pi * math.random()
	local r = math.sqrt(math.random()) * radius
	return {x = pos.x + r * math.cos(t), y = pos.y, z = pos.z + r * math.sin(t)}
end

function helpers.is_visible(pos, height, range)
	height = math.max(1, height or 0)
	for _, player in pairs(minetest.get_connected_players()) do
		local ppos = player:get_pos()
		-- Dont care about players way far away
		if vector.distance(ppos, pos) <= range then
			local eye = table.copy(ppos)
			eye.y = eye.y + player:get_properties().eye_height
			local look = player:get_look_dir()
			local dir = vector.direction(ppos, {x = pos.x, y = pos.y + height, z = pos.z})
			-- Only worry about players facing us
			if vector.dot(look, dir) > 0 then
				-- Check all visible parts
				for i = 0, height do
					if not Raycast(eye, vector.add(pos, {x = 0, y = i, z = 0}), false):next() then
						return true
					end
				end
			end
		end
	end
	return false
end

return helpers
