local schems = {}

-- Node Tables For The schematics
local floor_node = {name = "warehouse:floor"}
local rack_node = {name = "warehouse:rack"}
local air_node = {name = "air"}
local rack_light_node = {name = "warehouse:light", param2 = 1}
local aisle_light_node = {name = "warehouse:light", param2 = 0}
local row_sign_node = {name = "warehouse:row_sign"}

local function place_racks(schem, x, z, num)
	for i = 0, num - 1 do
		local x2 = x + (4 * i)
		local index = schematic.index(schem, {x = x2, y = 0, z = z})
		schem.data[index] = rack_node
	end
end

local function place_row_signs(schem, row_sign_positions)
	for _, v in ipairs(row_sign_positions) do
		local index1 = schematic.index(schems.aisle, {x = 0, y = 7, z = v})
		local index2 = schematic.index(schems.aisle, {x = 15, y = 7, z = v})

		schem.data[index1] = row_sign_node
		schem.data[index2] = row_sign_node
	end
end

-- Just a floor, used for borders currently
schems.floor = schematic.new({x = 16, y = 1, z = 16}, floor_node)

-- Rack Schematic
schems.rack = schematic.new({x = 16, y = 16, z = 16}, air_node)
schematic.fill_area(schems.rack, floor_node, {x = 0, y = 0, z = 0}, {x = 15, y = 0, z = 15})
place_racks(schems.rack, 0, 1, 4)
place_racks(schems.rack, 0, 9, 4)

local rack_light_index_1 = schematic.index(schems.rack, {x = 8, y = 9, z = 3})
schems.rack.data[rack_light_index_1] = rack_light_node

local rack_light_index_2 = schematic.index(schems.rack, {x = 8, y = 9, z = 12})
schems.rack.data[rack_light_index_2] = rack_light_node

-- Aisle Schematic
schems.aisle = schematic.new({x = 16, y = 16, z = 16}, air_node)
schematic.fill_area(schems.aisle, floor_node, {x = 0, y = 0, z = 0}, {x = 15, y = 0, z = 15})
place_row_signs(schems.aisle, {0, 1, 8, 9})

local aisle_light_index_1 = schematic.index(schems.aisle, {x = 2, y = 10, z = 8})
local aisle_light_index_2 = schematic.index(schems.aisle, {x = 13, y = 10, z = 8})

schems.aisle.data[aisle_light_index_1] = aisle_light_node
schems.aisle.data[aisle_light_index_2] = aisle_light_node

-- North Schematic
schems.north = schematic.new({x = 16, y = 16, z = 16}, air_node)
schematic.fill_area(schems.north, floor_node, {x = 0, y = 0, z = 0}, {x = 15, y = 0, z = 15})
place_racks(schems.north, 0, 1, 4)

-- North Aisle Schematic
schems.north_aisle = schematic.new({x = 16, y = 16, z = 16}, air_node)
schematic.fill_area(schems.north_aisle, floor_node, {x = 0, y = 0, z = 0}, {x = 15, y = 0, z = 15})
place_row_signs(schems.north_aisle, {0, 1})

-- South Schematic
schems.south = schematic.new({x = 16, y = 16, z = 16}, air_node)
schematic.fill_area(schems.south, floor_node, {x = 0, y = 0, z = 0}, {x = 15, y = 0, z = 15})
place_racks(schems.south, 0, 9, 4)

-- South Aisle Schematic
schems.south_aisle = schematic.new({x = 16, y = 16, z = 16}, air_node)
schematic.fill_area(schems.south_aisle, floor_node, {x = 0, y = 0, z = 0}, {x = 15, y = 0, z = 15})
place_row_signs(schems.south_aisle, {8, 9})

return schems
