-- Staff Corpse Node                   --
-- Populates with items from items.lua --

local function randomtext(length)
	math.randomseed(math.random(os.clock() * os.time()))
	local chars = "`~.,!%^*-:;'\"        "
	local str = string.rep("%s", length):gsub("%%s", function()
		local idx = math.random(1, chars:len())
		return chars:sub(idx, idx)
	end)
	return str
end

local items = {
	function() -- Stickynote
		local stack = ItemStack("staff:stickynote")
		local meta = stack:get_meta()
		meta:set_int("palette_index", math.random(0, 3) * 64)
		stack:set_count(math.random(1, 30))
		return stack, 1
	end,
	function() -- Used stickynote
		local stack = ItemStack("staff:stickynote_used")
		local meta = stack:get_meta()
		local message = randomtext(math.random(4, 20))
		meta:set_string("description", "Sticky Note with Text:\n\"" .. message .. "\"")
		meta:set_string("message", message)
		meta:set_int("palette_index", math.random(0, 3) * 64)
		return stack, 2
	end,
	function() -- Pen
		local stack = ItemStack("staff:pen")
		stack:set_wear(math.random(1, 65535))
		return stack, 3
	end,
	function() -- ID
		return "staff:id", 25
	end,
	function() -- Notepad
		return "staff:notepad", 5
	end,
	function() -- Used notepad
		local stack = ItemStack("staff:notepad_used")
		local meta = stack:get_meta()
		local pages = {}
		local pcount = math.random(1, 20)
		for i = 1, pcount do
			local content = ""
			if math.random(1, pcount) == 1 then
				content = minetest.formspec_escape(randomtext(math.random(10, 200 / 3)))
			end
			pages[i] = content
		end
		meta:set_int("current_page", math.random(1, #pages))
		meta:set_string("pages", minetest.serialize(pages))
		return stack, 10
	end,
	function() -- Scanner
		return "staff:scanner", 50
	end,
}

minetest.register_node(":staff:corpse", {
	description = "SCP-3008-2 (Deceased)",
	drawtype = "mesh",
	mesh = "ikea_staff_member_dead.obj",
	tiles = {"ikea_staff_member.png"},
	selection_box = {type = "fixed", fixed = {-0.5, -0.5, 0, 0.5, 0, 3}},
	collision_box = {type = "fixed", fixed = {-0.5, -0.5, 0, 0.5, 0, 3}},
	walkable = false,
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	groups = {carryable = 1, falling_node = 1},
	on_construct = function(pos)
		-- Inventory randomizer
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		inv:set_size("main", 5)

		local contents = {}

		for i = 1, inv:get_size("main") do
			math.randomseed(math.random(os.clock() * os.time()))
			if math.random(1, 10) == 1 then -- An item will go in this slot
				while not contents[i] do
					local selection, chance = items[math.random(1, #items)]()
					if math.random(1, chance) == 1 then
						contents[i] = selection
					end
				end
			else
				contents[i] = ""
			end
		end

		meta:from_table({
			inventory = {
				main = contents
			},
			fields = {
				formspec = [[
					size[8,7]
					list[context;main;1.5,1;5,1]
					list[current_player;main;0,3;8,4]
					listring[context;main]
					listring[current_player;main]
				]],
			},
		})
	end,
	allow_metadata_inventory_put = function()
		return 0
	end,
})
