-- SCP-3008-2 IKEA Staff --
-- By GreenXenith        --

staff = {}

staff.PATH = minetest.get_modpath(minetest.get_current_modname())
staff.RANGE = 40 -- How large an area staff members cover

staff.randompos = function(pos, radius)
	local t = 2 * math.pi * math.random()
	local r = math.sqrt(math.random()) * radius
	return {x = pos.x + r * math.cos(t), y = pos.y, z = pos.z + r * math.sin(t)}
end

staff.is_visible = function(pos, height)
	height = height or 1
	height = math.max(1, height)
	for _, player in pairs(minetest.get_connected_players()) do
		local ppos = player:get_pos()
		-- Dont care about players way far away
		if vector.distance(ppos, pos) <= staff.RANGE then
			local eye = table.copy(ppos)
			eye.y = eye.y + player:get_properties().eye_height
			local look = player:get_look_dir()
			local dir = vector.direction(ppos, {x = pos.x, y = pos.y + height, z = pos.z})
			-- Only worry about players facing us
			if vector.dot(look, dir) > 0 then
				-- Check all visible parts
				for i = 0, height do
					if not Raycast(eye, vector.add(pos, {x = 0, y = i, z = 0}), false):next() then
						return true
					end
				end
			end
		end
	end
	return false
end

dofile(staff.PATH .. "/items.lua")
dofile(staff.PATH .. "/staff.lua")
dofile(staff.PATH .. "/spawning.lua")
dofile(staff.PATH .. "/corpse.lua")

-- Debug entities
minetest.register_entity("ikea_staff:debug", {
	visual = "sprite",
	textures = {"blank.png^[invert:a^[colorize:red"},
	visual_size = {x = 0.3, y = 0.3},
	on_activate = function(self, data)
		self.object:set_nametag_attributes({text = data})
		minetest.after(5, function()
			if self.object then
				self.object:remove()
			end
		end)
	end,
	on_punch = function(self)
		self.object:remove()
	end,
})
