local error_message = [[
Function %s does not pass self-test!
Expected results: %s
Test Results: %s
]]

do -- table.equals
	local test_table = {"a", "b", c = false, e = {"f", "g", "h", {"h"}}}
	table.insert(test_table, test_table)
	local results = table.equals(test_table, test_table)
	local error = error_message:format("table.equals", "true", tostring(results))
	assert(results, error)

	local results2 = not table.equals({a = 1}, {a = 2})
	local error2 = error_message:format("table.equals", "false", tostring(results2))
	assert(results2, error2)
end
