local day_color = "#414141"
local night_color = "#303030"

-- Sets the skybox and global light level for player
local function update_player_time(player)
	local is_open = ikea.is_open()

	if is_open then
		player:override_day_night_ratio(0.7)
		player:set_sky(day_color, "plain", {}, false)
	else
		player:override_day_night_ratio(0)
		player:set_sky(night_color, "plain", {}, false)
	end
end

minetest.register_on_joinplayer(function(player)
	update_player_time(player)
end)

util.register_on_tod(ikea.opening_time, function()
	for _, player in ipairs(minetest.get_connected_players()) do
		update_player_time(player)
	end
end)

util.register_on_tod(ikea.closing_time, function()
	for _, player in ipairs(minetest.get_connected_players()) do
		update_player_time(player)
		minetest.sound_play({name = "ikea_power_down", gain = 0.15, pitch = 1.0})
	end
end)
