-- Staff Spawning --

local TRIES = 20 -- How many times to try finding a valid spawn point before giving up
local rate = 15
local timer = 0

minetest.register_globalstep(function(dt)
	timer = timer + dt
	if timer >= rate then
		for _, player in pairs(minetest.get_connected_players()) do
			local pos = player:get_pos()

			local count = 0
			for _, entity in pairs(minetest.luaentities) do
				if entity.name == "ikea_staff:member" then
					if vector.distance(pos, entity.object:get_pos()) <= staff.RANGE then
						count = count + 1
					end
				end
			end

			if count < 2 then -- math.floor(player:get_meta():get_float("age") / 7)
				local tries = 0
				while tries <= TRIES do
					local spawnat = staff.randompos(pos, staff.RANGE)
					if not minetest.registered_nodes[minetest.get_node(spawnat).name].walkable then
						if staff.is_visible(spawnat, 3) then
							tries = tries + 1
						else
							spawnat.y = 2
							minetest.add_entity(spawnat, "ikea_staff:member")
							break
						end
					else
						tries = tries + 1
					end
				end
			end
		end

		timer = 0
	end
end)
