local listerby_box = {
	type = "fixed",
	fixed = {
		{-0.25, 0.00125, -0.3125, 1.25, -0.06125, 0.3125}, -- Tabletop
		{-0.0625, -0.06125, -0.25, 0.0, -0.49875, 0.25}, -- Left
		{1.0, -0.06125, -0.25, 1.0625, -0.49875, 0.25}, -- Right
		{0.0, -0.31125, -0.25, 1.0, -0.37375, 0.25}, -- Shelf
	},
}

local listerby_def = ikea.default_furniture_def()
listerby_def.description = "Listerby Table"
listerby_def.mesh = "ikea_tables_listerby.obj"
listerby_def.tiles = {"ikea_tables_listerby.png"}
listerby_def.selection_box = listerby_box
listerby_def.collision_box = listerby_box
listerby_def.groups.size_x = 2
listerby_def.groups.table = 1
listerby_def.groups.lounge = 1
listerby_def.box_contents = {"ikea:furniture_board", "ikea:furniture_leg", "ikea:furniture_leg", "ikea:furniture_leg", "ikea:furniture_leg"}
listerby_def.tool_capabilities = {
	full_punch_interval = 6,
	damage_groups = {whacking = 15}
}

minetest.register_node(":tables:listerby", listerby_def)

local lisabo_box = {
	type = "fixed",
	fixed = {
		{-0.625, 0.5, -0.5625, 1.625, 0.4375, 0.5625}, -- Tabletop
		{-0.5625, 0.4375, -0.5, 1.5625, 0.375, 0.5}, -- Lower Tabletop
		{1.4375, 0.375, -0.4375, 1.5, -0.5, -0.375}, -- Front Right Leg
		{1.4375, 0.375, 0.375, 1.5, -0.5, 0.4375}, -- Back Right Leg
		{-0.5, 0.375, -0.4375, -0.4375, -0.5, -0.375}, -- Front Left Leg
		{-0.5, 0.375, 0.375, -0.4375, -0.5, 0.4375}, -- Back Left Leg
	},
}

local lisabo_def = ikea.default_furniture_def()
lisabo_def.description = "Lisabo Table"
lisabo_def.mesh = "ikea_tables_lisabo.obj"
lisabo_def.tiles = {"ikea_tables_lisabo.png"}
lisabo_def.selection_box = lisabo_box
lisabo_def.collision_box = lisabo_box
lisabo_def.groups.size_x = 2
lisabo_def.groups.table = 1
lisabo_def.groups.kitchen = 1
lisabo_def.box_contents = {"ikea:furniture_board", "ikea:furniture_leg", "ikea:furniture_leg", "ikea:furniture_leg", "ikea:furniture_leg"}
lisabo_def.tool_capabilities = {
	full_punch_interval = 6,
	damage_groups = {whacking = 15}
}

minetest.register_node(":tables:lisabo", lisabo_def)
