local error_message = [[
Function %s does not pass self-test!
Expected results: %s
Test Results: %s
]]

do -- table.equals
	local test_table = {"a", "b", c = false, e = {"f", "g", "h", {"h"}}}
	table.insert(test_table, test_table)
	local results = table.equals(test_table, test_table)
	local error = error_message:format("table.equals", "true", tostring(results))
	assert(results, error)

	local results2 = not table.equals({a = 1}, {a = 2})
	local error2 = error_message:format("table.equals", "false", tostring(results2))
	assert(results2, error2)
end

do -- util.astar
	local max = 100
	local grid, coords, display, id = {}, {}, {}, 1

	local function get_neighbors(node)
		local x, y = unpack(coords[node])
		local neighbors = {}
		if x > 1 then
			table.insert(neighbors, grid[x-1][y])
		end
		if x < max then
			table.insert(neighbors, grid[x+1][y])
		end
		if y > 1 then
			table.insert(neighbors, grid[x][y-1])
		end
		if y < max then
			table.insert(neighbors, grid[x][y+1])
		end
		return neighbors
	end
	
	local function is_good_node(node)
		return true
	end

	local function get_cost(a, b)
		local x, y = unpack(coords[b])
		return (x > 1) and (x < 20) and (y > 2) and (y < 15) and 10 or 1
	end

	local function get_heuristic(a, b)
		local a_x, a_y = unpack(coords[a])
		local b_x, b_y = unpack(coords[b])
		return math.abs(a_x - b_x) + math.abs(a_y - b_y)
	end

	for x = 1, max do
		grid[x] = {}
		display[x] = {}
		for y = 1, max do
			grid[x][y] = id
			coords[id] = {x,y}
			id = id + 1
			display[x][y] = get_cost(nil, grid[x][y]) == 10 and "/" or "."
		end
	end

	for _, node in ipairs(util.astar(grid[2][2], grid[60][60], get_neighbors, is_good_node, get_cost, get_heuristic)) do
		local x, y = unpack(coords[node])
		display[x][y] = "#"
	end

	for y=1, max do
		for x=1, max do
			io.write(display[x][y] .. " ")
		end
		io.write("\n")
	end
end

