--[[
File: init.lua
Location: list_to_file mod for Luanti
Author: bgstack15
SPDX-License-Identifier: GPL-3.0
Startdate: 2025-02-28
Title: List_to_file main logic
Purpose: main functions
History:
Usage: Install the mod. Modify settings in minetest.conf
Reference:
	https://forum.luanti.org/viewtopic.php?p=264854#p264854
	https://gitea.your-land.de/your-land/yl_ticker/src/branch/master/globalsteps.lua
Improve:
Dependencies: only tested against luanti >= 5.11.0
]]--

-- Get world path and name
local path = core.get_worldpath()
local worldname = path:match( "([^/]+)$" )

local function list_to_file()
	local out, err = io.open(path .. "/active-players.txt", 'wb')
	if not out then
		return true, err
	end
	local n = 0
	local players = ""
	for player in mcl_util.connected_players() do
		players = players..player:get_player_name() .. "\n"
		n = n + 1
	end
	out:write(players)
	out:close()
	local message = worldname .. ": listed " .. n .. " users to file active-players.txt"
	core.log("info",message)
	-- .. os.date("!%H:%M:%S", os.time()))
	return true, message
end

-- register command /list_to_file which provides the function to server admins.
core.register_chatcommand("list_to_file", {
	description = "List who is logged on to a file",
	params = "",
	privs = { server = true },
	func = list_to_file
})

-- We only load the setting at game start.
local listing_seconds = -1
if core.settings:get("listing_seconds") then
	listing_seconds = tonumber(core.settings:get("listing_seconds"))
end
if (listing_seconds == -1) then
	listing_seconds = 60
end

local timer = 0
local gs = function(dtime)
	timer = timer + dtime
	--core.log("info","with delta " .. listing_seconds .. " got timer value " .. timer)
	if timer <= listing_seconds then return end
	timer = timer - listing_seconds
	-- time to run the function
	list_to_file()
end

if (listing_seconds > 0) then
	core.register_globalstep(gs)
	core.log("info","list_to_file will use listing_seconds " .. listing_seconds)
else
	core.log("info","list_to_file is disabled via settings.")
end
