-- SPDX-License-Identifier: GPL-3.0-only
local S = core.get_translator(core.get_current_modname())

mcl_armor.register_set({
	name = "lapis",
	descriptions = {
		head = S("Lapis Helmet"),
		torso = S("Lapis Chestplate"),
		legs = S("Lapis Leggings"),
		feet = S("Lapis Boots"),
	},	durability = 555,
	enchantability = 10,
	points = {
		head = 3,
		torso = 8,
		legs = 6,
		feet = 3,
	},
	groups = { fire_immune=1 },
	toughness = 2,
	repair_material = "mcl_core:lapis",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

mcl_tools.register_set("lapis", {
	craftable = true,
	material = "mcl_core:lapis",
	uses = 2031,
	level = 6,
	speed = 9.5,
	max_drop_level = 5,
	groups = { dig_speed_class = 6, enchantability = 10, fire_immune = 1 }
}, {
	["pick"] = {
		description = S("Lapis Pickaxe"),
		inventory_image = "default_tool_lapispick.png",
		tool_capabilities = {
			full_punch_interval = 0.83333333,
			damage_groups = { fleshy = 5 }
		}
	},
	["shovel"] = {
		description = S("Lapis Shovel"),
		inventory_image = "default_tool_lapisshovel.png",
		tool_capabilities = {
			full_punch_interval = 1,
			damage_groups = { fleshy = 4 }
		}
	},
	["sword"] = {
		description = S("Lapis Sword"),
		inventory_image = "default_tool_lapissword.png",
		tool_capabilities = {
			full_punch_interval = 0.625,
			damage_groups = { fleshy = 10 }
		}
	},
	["axe"] = {
		description = S("Lapis Axe"),
		inventory_image = "default_tool_lapisaxe.png",
		tool_capabilities = {
			full_punch_interval = 1.25,
			damage_groups = { fleshy = 8 }
		}
	}
})

-- [[
-- BEGIN HOE, adapted from mcl_copper_stuff
local hoe_tt = S("Turns block into farmland")
local hoe_longdesc = S("Hoes are essential tools for growing crops. They are used to create farmland in order to plant seeds on it. Hoes can also be used as very weak weapons in a pinch.")
local hoe_usagehelp = S("Use the hoe on a cultivatable block (by rightclicking it) to turn it into farmland. Dirt, grass blocks and grass paths are cultivatable blocks. Using a hoe on coarse dirt turns it into dirt.")

local function create_soil(pos, inv)
	if pos == nil then
		return false
	end
	local node = minetest.get_node(pos)
	local name = node.name
	local above = minetest.get_node({x=pos.x, y=pos.y+1, z=pos.z})
	if minetest.get_item_group(name, "cultivatable") == 2 then
		if above.name == "air" then
			node.name = "mcl_farming:soil"
			minetest.set_node(pos, node)
			minetest.sound_play("default_dig_crumbly", { pos = pos, gain = 0.5 }, true)
			return true
		end
	elseif minetest.get_item_group(name, "cultivatable") == 1 then
		if above.name == "air" then
			node.name = "mcl_core:dirt"
			minetest.set_node(pos, node)
			minetest.sound_play("default_dig_crumbly", { pos = pos, gain = 0.6 }, true)
			return true
		end
	end
	return false
end

local hoe_on_place_function = function(wear_divisor)
	return function(itemstack, user, pointed_thing)
		-- Call on_rightclick if the pointed node defines it
		local node = minetest.get_node(pointed_thing.under)
		if user and not user:get_player_control().sneak then
			if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
				return minetest.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, user, itemstack) or itemstack
			end
		end
		if minetest.is_protected(pointed_thing.under, user:get_player_name()) then
			minetest.record_protection_violation(pointed_thing.under, user:get_player_name())
			return itemstack
		end
		if create_soil(pointed_thing.under, user:get_inventory()) then
			if not minetest.is_creative_enabled(user:get_player_name()) then
				itemstack:add_wear(65535/wear_divisor)
			end
			return itemstack
		end
	end
end

local uses = 2031
minetest.register_tool("mcl_lapis_stuff:lapis_hoe", {
	description = S("Lapis Hoe"),
	_tt_help = hoe_tt.."\n"..S("Uses: @1", uses),
	_doc_items_longdesc = hoe_longdesc,
	_doc_items_usagehelp = hoe_usagehelp,
	inventory_image = "default_tool_lapishoe.png",
	wield_scale = mcl_vars.tool_wield_scale,
	on_place = hoe_on_place_function(uses),
	groups = { tool=1, hoe=1, enchantability=9 },
	tool_capabilities = {
		full_punch_interval = 1,
		damage_groups = { fleshy = 1, },
		punch_attack_uses = uses,
	},
	_repair_material = "mcl_core:lapis",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		hoey = { speed = 10, level = 2, uses = uses }
	},
})
-- END HOE
-- ]]

core.register_craftitem("mcl_lapis_stuff:lapis_horse_armor", {
	description = S("Lapis Horse Armor"),
	_doc_items_longdesc = S("Lapis horse armor can be worn by horses to greatly increase their protection from harm."),
	_doc_items_usagehelp = S("Place it on a horse to put on the horse armor. Donkeys and mules can't wear horse armor."),
	inventory_image = "mcl_lapis_stuff_lapis_horse_armor.png",
	_horse_overlay_image = "mcl_lapis_stuff_horse_armor_lapis.png",
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_diamond",
	},
	stack_max = 1,
	groups = { horse_armor = 48 },
})
