-- This depends on https://codeberg.org/mineclonia/mineclonia/pulls/3472 which is mineclonia >0.115.0
local S = core.get_translator(core.get_current_modname())
local C = core.colorize
local modname = core.get_current_modname()

-- Reset food poisoning and status effects
local function drink_chocolate_milk(itemstack, player, pointed_thing)
   local bucket = core.do_item_eat(2, "mcl_buckets:bucket_empty", itemstack, player, pointed_thing)
   -- Check if we were allowed to drink this (eat delay check)
   if mcl_hunger.active and (bucket:get_name() ~= "milk_potion:chocolate_milk_bucket" or core.is_creative_enabled(player:get_player_name())) then
      mcl_hunger.stop_poison(player)
   end
   mcl_potions._reset_effects(player)
   return bucket
end

mcl_potions.register_potion({
   name = "soothing",
   _id_override = modname .. ":soothing",
   desc_prefix = "Soothing",
   groups = {brewitem=1, food=3, can_eat_when_full=1,
   _mcl_potion=1, potion=1, rarity=1},
   _tt = "Removes effects.",
   color = "#f9f9f9",
   has_splash = true,
   has_lingering = true,
   has_arrow = true,
   custom_effect = function(user, level)
      mcl_potions._reset_effects(user)
   end,
})

mcl_potions.register_ingredient_potion("mcl_potions:glass_bottle", {
   ["mcl_mobitems:milk_bucket"] = "milk_potion:soothing"
})

core.register_craft({
   type = "shapeless",
   output = "milk_potion:soothing 3",
   recipe = {
      "mcl_mobitems:milk_bucket",
      "mcl_potions:glass_bottle",
      "mcl_potions:glass_bottle",
      "mcl_potions:glass_bottle"
   },
   replacements = { { "mcl_mobitems:milk_bucket", "mcl_buckets:bucket_empty" } }
})

core.register_craftitem("milk_potion:chocolate_milk_bucket", {
   description = "Chocolate milk",
   _tt_help = C(mcl_colors.GREEN, S("Removes all status effects")),
   _doc_items_longdesc = "Chocolate milk is very refreshing. Drinking it will remove all status effects and restores a small amount of hunger points.",
   _doc_items_usagehelp = "Use the placement key to drink the chocolate milk.",
   inventory_image = "milk_potion_bucket_chocolate_milk.png",
   wield_image = "milk_potion_bucket_chocolate_milk.png",
   on_place = drink_chocolate_milk,
   on_secondary_use = drink_chocolate_milk,
   stack_max = 1,
   groups = { food = 3, can_eat_when_full = 1, eatable = 2 },
   _mcl_saturation = 2.0
})

core.register_craft({
   type = "shapeless",
   output = "milk_potion:chocolate_milk_bucket",
   recipe = {"mcl_mobitems:milk_bucket","mcl_cocoas:cocoa_beans"}
})
