-- File: obsidian_extra.lua
-- Author: bgstack15
-- SPDX-License-Identifier: GPL-3.0-only
local has_mcl_doors = core.get_modpath("mcl_doors") ~= nil
local has_mcl_fences = core.get_modpath("mcl_fences") ~= nil
local has_mcl_walls = core.get_modpath("mcl_walls") ~= nil
local has_mcl_buttons = core.get_modpath("mcl_buttons") ~= nil
local has_mcl_stairs = core.get_modpath("mcl_stairs") ~= nil
local has_mcl_sounds = core.get_modpath("mcl_sounds") ~= nil
local has_mcl_pressureplates = core.get_modpath("mcl_pressureplates") ~= nil

local obsidian_sounds = has_mcl_sounds and mcl_sounds.node_sound_stone_defaults() or nil

local mod_name = core.get_current_modname()
local OBSIDIAN = obsidian_extra.OBSIDIAN
local TEXTURE = obsidian_extra.TEXTURE
local HARDNESS = obsidian_extra.HARDNESS
local RESIST = obsidian_extra.BLAST_RESISTANCE

if not has_mcl_doors then
	core.log("warning","[" .. mod_name .. "] Cannot load obsidian door because cannot find mod mcl_doors.")
else

	-- register_door() does not pass the def {} here directly, so 
	-- _mcl_stonecutter_recipes = {"mcl_core:obsidian"} does not work.
	-- And because a door is 2 nodes, I was unable to get a door as
	-- a valid item in the stonecutter output anyway.
	mcl_doors:register_door("obsidian_extra:door_obsidian", {
		description = "Obsidian Door",
		_doc_items_longdesc = "Obsidian doors are 2-block high barriers that can be opened by hand or by redstone signal.",
		_doc_items_usagehelp = "To open or close an obsidian door, right-click or supply a redstone signal.",
		inventory_image = "doors_item_obsidian.png",
		groups = {pickaxey=1, door_iron=1},
		_mcl_hardness = HARDNESS,
		_mcl_blast_resistance = RESIST,
		tiles_bottom = {"obsidian_extra_door_obsidian_lower.png^[transformFX","obsidian_extra_door_obsidian_lower.png"},
		tiles_top = {"obsidian_extra_door_obsidian_upper.png^[transformFX","obsidian_extra_door_obsidian_upper.png"},
		sounds = obsidian_sounds,
		sound_open = "doors_steel_door_open",
		sound_close = "doors_steel_door_close",
		only_redstone_can_open = false
	})
	core.override_item("obsidian_extra:door_obsidian", { _mcl_stonecutter_recipes = {OBSIDIAN}})

	core.register_craft({
		output = "obsidian_extra:door_obsidian 3",
		recipe = {
			{OBSIDIAN, OBSIDIAN},
			{OBSIDIAN, OBSIDIAN},
			{OBSIDIAN, OBSIDIAN}
		}
	})

	-- Function register_trapdoor() does not pass the def {} here
	-- directly, so _mcl_stonecutter_recipes = {"mcl_core:obsidian"}
	-- does not work. It works if we do it separately below.
	mcl_doors:register_trapdoor("obsidian_extra:trapdoor_obsidian", {
		description = "Obsidian Trapdoor",
		_doc_items_longdesc = "Obsidian trapdoors can be opened by hand or redstone signal.",
		_doc_items_usagehelp = "To open or close an obsidian trapdoor, right-click or supply a redstone signal.",
		tile_front = "obsidian_extra_trapdoor_obsidian.png",
		wield_image = "obsidian_extra_trapdoor_obsidian.png",
		groups = {pickaxey=1},
		_mcl_hardness = HARDNESS,
		_mcl_blast_resistance = RESIST,
		sounds = mcl_sounds.node_sound_metal_defaults(),
		sound_open = "doors_steel_door_open",
		sound_close = "doors_steel_door_close",
		only_redstone_can_open = false
	})
	-- add trapdoor to stonecutter
	core.override_item("obsidian_extra:trapdoor_obsidian", { _mcl_stonecutter_recipes = {OBSIDIAN}})
	-- make it provide 4 per cut item, by exploiting this value
	obsidian_extra.override_groups("obsidian_extra:trapdoor_obsidian", { cut_copper = 1 })

	core.register_craft({
		output = "obsidian_extra:trapdoor_obsidian",
		recipe = {
			{OBSIDIAN, OBSIDIAN},
			{OBSIDIAN, OBSIDIAN}
		}
	})

end -- if mcl_doors

if not has_mcl_fences then
	core.log("warning","[" .. mod_name .. "] Cannot load obsidian fences because cannot find mod mcl_doors.")
else

	--[[
	-- attempt 1: the supposed frontend of mcl_fences API but it does not have a spot for overrides like for red_nether_brick_fence.
	mcl_fences.register_fence_and_fence_gate(
		"obsidian",
		"Obsidian fence",
		"Obsidian fence gate",
		"default_obsidian.png",
		{ pickaxey = 1, fence_obsidian = 1},
		40,
		1100,
		{ "group:fence_obsidian", "group:solid" },
		obsidian_sounds, -- sounds: nil means use default?
		"mcl_fences_nether_brick_fence_gate_open",
		"mcl_fences_nether_brick_fence_gate_close"
	)
	--]]
	mcl_fences.register_fence_and_fence_gate_def(
		"fence_obsidian", {
			tiles = { TEXTURE },
			groups = { fence_obsidian = 1, pickaxey = 1},
			sounds = obsidian_sounds,
			_mcl_stonecutter_recipes = {OBSIDIAN},
			_mcl_hardness = HARDNESS,
			_mcl_blast_resistance = RESIST,
			_mcl_fences_baseitem = OBSIDIAN,
			_mcl_fences_stickreplacer = "mcl_stairs:slab_obsidian"
		},
		{ -- description
			description = "Obsidian Fence",
			connects_to = { "group:fence_obsidian", "group:solid" }
		},
		{ -- gate description
			description = "Obsidian Fence Gate",
			_mcl_fences_sounds = {
				open = { "mcl_fences_nether_brick_fence_gate_open" },
				close = { "mcl_fences_nether_brick_fence_gate_close" }
			},
			_mcl_fences_output_amount = 2
		}
	)

end -- if mcl_fences

if not has_mcl_walls then
	core.log("warning","[" .. mod_name .. "] Cannot load obsidian walls because cannot find mod mcl_walls.")
else
	-- truly, underscores break this.
	mcl_walls.register_wall("obsidian_extra:wallobsidian",
		"Obsidian wall",
		OBSIDIAN,
		nil, nil, nil, nil, -- tiles, inventory_image, groups, sounds
		{ -- overrides
			_mcl_hardness = HARDNESS,
			_mcl_blast_resistance = RESIST,
		}
	)
end

if not has_mcl_buttons then
	core.log("warning","[" .. mod_name .. "] Cannot load obsidian button because cannot find mod mcl_buttons.")
else
	-- register_button() does not pass the def {} here directly, so 
	-- _mcl_stonecutter_recipes = {"mcl_core:obsidian"} does not work, but
	-- this recipe is so simple it does not matter.
	mcl_buttons.register_button("obsidian", {
		description = "Obsidian Button",
		texture = TEXTURE,
		recipeitem = OBSIDIAN,
		sounds = obsidian_sounds,
		groups = {material_obsidian=1,handy=1,axey=1},
		push_by_arrow = false,
		longdesc = "An obsidian button can be pushed by hand to send a redstone signal for 1 second.",
		push_duration = 10,
		push_sound = "mesecons_button_push",
		burntime = nil
	})
end

if not has_mcl_stairs then
	core.log("warning","[" .. mod_name .. "] Cannot load obsidian stairs because cannot find mod mcl_stairs.")
else
	mcl_stairs.register_stair_and_slab("obsidian", {
		baseitem = OBSIDIAN,
		description_stair = "Obsidian Stairs",
		description_slab = "Obsidian Slab",
		overrides = {
			_mcl_stonecutter_recipes = {OBSIDIAN},
			_mcl_hardness = HARDNESS,
			_mcl_blast_resistance = RESIST
		}
	})
end

if not has_mcl_pressureplates then
	core.log("warning","[" .. mod_name .. "] Cannot load obsidian pressure plate because cannot find mod mcl_pressureplates.")
else
	mcl_pressureplates.register_pressure_plate("obsidian", {
		description = "Obsidian Pressure Plate",
		texture = TEXTURE,
		recipeitem = OBSIDIAN,
		sounds = obsidian_sounds,
		groups = {pickaxey=1, material_stone=1},
		activated_by = { player = true, mob = true },
		longdesc = "An obsidian pressure plate is a redstone component which supplies its surrounding blocks with redstone power while a player or mob stand on top of it. It is not triggered by anything else."
	})
	-- add pressure plate to stonecutter
	core.override_item("mcl_pressureplates:pressure_plate_obsidian_off", { _mcl_stonecutter_recipes = {OBSIDIAN}})
	-- make it provide 4 per cut item, by exploiting this value
	obsidian_extra.override_groups("mcl_pressureplates:pressure_plate_obsidian_off", { cut_copper = 1 })
end

-- add the ability to use stonecutter on obsidian
obsidian_extra.override_groups(OBSIDIAN,{stonecuttable=1})
