-- vim: set ts=4 sw=4 sts=4 noet si: --
-- SPDX-License-Identifier: AGPL-3.0-only
-- privs_per_world = ppw
ppw = {}
local modname = core.get_current_modname()
ppw.i18n = core.get_translator(modname)
ppw.modpath = core.get_modpath(modname)
local S = ppw.i18n

-- Load settings from config file
dofile(ppw.modpath .. "/settings.lua")

local function split_string(inputstr, sep)
	if sep == nil then
		sep = "%s"
	end
	local t = {}
	for part in string.gmatch(inputstr, "([^" .. sep .. "]+)") do
		table.insert(t, part)
	end
	return t
end

local function set_priv(player, priv, give)
	-- give is boolean, true = give, false = take
	local pname = player:get_player_name()
	local privs = core.get_player_privs(pname)
	if privs[priv] == give then
		return
	end
	if give then
		privs[priv] = give
	else
		privs[priv] = nil
	end
	core.set_player_privs(pname, privs)
end

local function change_dimension(player, dimension, previous_dimension)
	-- When the player users a regular nether portal, this function is 
	-- called twice, with pdimension being used separately from dimension.
	-- When teleporting to a position, both parameters are used in one 
	-- function call.
	local pname = player:get_player_name()
	local pdimension = previous_dimension
	if dimension == nil then dimension = "" end
	if pdimension == nil then pdimension = "" end
	core.log("info", pname .. " entering " .. dimension .. ", leaving " .. pdimension)
	-- leave
	if pdimension and (ppw.settings[pdimension] ~= nil) then
		if ppw.settings[pdimension]["leave"] ~= nil then
			if ppw.settings[pdimension]["leave"]["give"] ~= nil then
				for _, priv in ipairs(split_string(ppw.settings[pdimension]["leave"]["give"], ",")) do
					core.log("action", "Granting " .. priv .. " to " .. pname .. " upon leaving " .. pdimension)
					set_priv(player, priv, true)
				end
			end
			if ppw.settings[pdimension]["leave"]["take"] ~= nil then
				for _, priv in ipairs(split_string(ppw.settings[pdimension]["leave"]["take"], ",")) do
					core.log("action", "Revoking " .. priv .. " from " .. pname .. " upon leaving " .. pdimension)
					set_priv(player, priv, false)
				end
			end
		end
	end
	-- enter
	if dimension and(ppw.settings[dimension] ~= nil) then
		if ppw.settings[dimension]["enter"] ~= nil then
			if ppw.settings[dimension]["enter"]["give"] ~= nil then
				for _, priv in ipairs(split_string(ppw.settings[dimension]["enter"]["give"], ",")) do
					core.log("action", "Granting " .. priv .. " to " .. pname .. " upon entering " .. dimension)
					set_priv(player, priv, true)
				end
			end
			if ppw.settings[dimension]["enter"]["take"] ~= nil then
				for _, priv in ipairs(split_string(ppw.settings[dimension]["enter"]["take"], ",")) do
					core.log("action", "Revoking " .. priv " from " .. pname .. " upon entering " .. dimension)
					set_priv(player, priv, false)
				end
			end
		end
	end
end

-- This successfully triggers even when using mod respawn or /teleport,
-- So nothing else is needed.
mcl_worlds.register_on_dimension_change(change_dimension)

core.register_on_priv_grant(function(name, granter, priv)
	-- short-circuit if granter is empty. Granter will have a value if a player called it and it is important.
	if granter == nil then return end
	-- FUTUREIMPROVEMENT: loop over privs given and taken for current world of <name>, and if the priv matches, then update the stored table value for the player.
	if priv == "fly" then
		core.log("warning","Yup, fly is being granted to " .. name .. " by " .. granter)
	end
end)
