local is_farming_redo = minetest.get_modpath("farming") ~= nil
and farming ~= nil and farming.mod == "redo"

local S = farmtools.i18n

minetest.register_tool("farmtools:sickle_bronze", {
	description = S("Bronze Sickle"),
	inventory_image = "sickles_sickle_bronze.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level = 1,
		groupcaps = {
			snappy = { times = { [1] = 2.75, [2] = 1.30, [3] = 0.375 }, uses = 100, maxlevel = 2 }
		},
		damage_groups = { fleshy = 3 },
		punch_attack_uses = 100
	},
	range = 6,
	groups = { sickle = 1, sickle_uses = 200 },
	sound = { breaks = "default_tool_breaks" }
})

minetest.register_craft({
	output = "farmtools:sickle_bronze",
	recipe = {
		{ "default:bronze_ingot", "" },
		{ "", "default:bronze_ingot" },
		{ "group:stick", "" }
	}
})

minetest.register_tool("farmtools:sickle_steel", {
	description = S("Steel Sickle"),
	inventory_image = "sickles_sickle_steel.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level = 1,
		groupcaps = {
			snappy = { times = { [1] = 2.5, [2] = 1.20, [3] = 0.35 }, uses = 150, maxlevel = 2 }
		},
		damage_groups = { fleshy = 3 },
		punch_attack_uses = 150
	},
	range = 6,
	groups = { sickle = 1, sickle_uses = 300 },
	sound = { breaks = "default_tool_breaks" }
})

minetest.register_craft({
	output = "farmtools:sickle_steel",
	recipe = {
		{ "default:steel_ingot", "" },
		{ "", "default:steel_ingot" },
		{ "group:stick", "" }
	}
})

minetest.register_tool("farmtools:sickle_gold", {
	description = S("Golden Sickle"),
	inventory_image = "sickles_sickle_gold.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level = 1,
		groupcaps = {
			snappy = { times = { [1] = 2.0, [2] = 1.00, [3] = 0.35 }, uses = 80, maxlevel = 3 }
		},
		damage_groups = { fleshy = 2 },
		punch_attack_uses = 80
	},
	range = 6,
	groups = { sickle = 1, sickle_uses = 160 },
	sound = { breaks = "default_tool_breaks" }
})

minetest.register_craft({
	output = "farmtools:sickle_gold",
	recipe = {
		{ "default:gold_ingot", "" },
		{ "", "default:gold_ingot" },
		{ "group:stick", "" }
	}
})

minetest.register_tool("farmtools:scythe_bronze", {
	description = S("Bronze Scythe"),
	inventory_image = "sickles_scythe_bronze.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		damage_groups = { fleshy = 5 },
		punch_attack_uses = 200
	},
	range = 12,
	on_use = farmtools.use_scythe,
	groups = { scythe = 2, scythe_uses = 100 },
	sound = { breaks = "default_tool_breaks" }
})

minetest.register_craft({
	output = "farmtools:scythe_bronze",
	recipe = {
		{ "", "default:bronze_ingot", "default:bronze_ingot" },
		{ "default:bronze_ingot", "", "group:stick" },
		{ "", "", "group:stick" }
	}
})

minetest.register_tool("farmtools:scythe_steel", {
	description = S("Steel Scythe"),
	inventory_image = "sickles_scythe_steel.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		damage_groups = { fleshy = 5 },
		punch_attack_uses = 300
	},
	range = 12,
	on_use = farmtools.use_scythe,
	groups = { scythe = 2, scythe_uses = 150 },
	sound = { breaks = "default_tool_breaks" }
})

minetest.register_craft({
	output = "farmtools:scythe_steel",
	recipe = {
		{ "", "default:steel_ingot", "default:steel_ingot" },
		{ "default:steel_ingot", "", "group:stick" },
		{ "", "", "group:stick" }
	}
})

minetest.register_tool("farmtools:scythe_diamond", {
	description = S("Diamond Scythe"),
	inventory_image = "farmtools_scythe_diamond.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		damage_groups = { fleshy = 5 },
		punch_attack_uses = 500
	},
	range = 12,
	on_use = farmtools.use_scythe,
	groups = { scythe = 2, scythe_uses = 500 },
	sound = { breaks = "default_tool_breaks" }
})

minetest.register_craft({
	output = "farmtools:scythe_diamond",
	recipe = {
		{ "", "default:diamond", "default:diamond" },
		{ "default:diamond", "", "group:stick" },
		{ "", "", "group:stick" }
	}
})

minetest.register_tool("farmtools:sickle_diamond", {
	description = S("Diamond Sickle"),
	inventory_image = "farmtools_sickle_diamond.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level = 1,
		groupcaps = {
			snappy = { times = { [1] = 1.75, [2] = 0.8, [3] = 0.25 }, uses = 250, maxlevel = 3 }
		},
		damage_groups = { fleshy = 2 },
		punch_attack_uses = 250
	},
	range = 6,
	groups = { sickle = 1, sickle_uses = 300 },
	sound = { breaks = "default_tool_breaks" }
})


minetest.register_craft({
	output = "farmtools:sickle_diamond",
	recipe = {
		{ "default:diamond", "" },
		{ "", "default:diamond" },
		{ "group:stick", "" }
	}
})

if is_farming_redo then
	-- softly disable mithril scythe to prevent confusion
	minetest.override_item("farming:scythe_mithril", {
		groups = { not_in_creative_inventory = 1 }
	})
	minetest.clear_craft({
		output = "farming:scythe_mithril"
	})
end
