-- LUALOCALS < ---------------------------------------------------------
local include, nodecore, pairs, string
    = include, nodecore, pairs, string
local string_lower
    = string.lower
-- LUALOCALS > ---------------------------------------------------------

include("rules")

local modname = minetest.get_current_modname()

local function reg(name, basename, basedef)
    local piecename = modname .. ":stone_" .. string_lower(name)
    if minetest.registered_nodes[piecename] then return end
    local desc = basedef.description or name

    local nodeDesc

    local nameStone = string.match(desc, "(.*)stone$")
    if nameStone then
        nodeDesc = nameStone
    elseif desc == "Stone" then
        nodeDesc = "Go"
    else
        nodeDesc = desc
    end
    nodeDesc = nodeDesc .. " Stone"

    minetest.register_node(":" .. piecename, {
        description = nodeDesc,
        drawtype = "nodebox",

        node_box = {
            type = "fixed",
            fixed = {
                {-3/16, -8/16, -3/16, 3/16, -7/16, 3/16},
                {-5/16, -7/16, -5/16, 5/16, -6/16, 5/16},
                {-6/16, -6/16, -6/16, 6/16, -4/16, 6/16},
                {-7/16, -4/16, -7/16, 7/16, -2/16, 7/16},
                {-6/16, -2/16, -6/16, 6/16, 0/16, 6/16},
                {-5/16, 0/16, -5/16, 5/16, 1/16, 5/16},
                {-3/16, 1/16, -3/16, 3/16, 2/16, 3/16},
            }
        },

        selection_box = {
            type = "fixed",
            fixed = {-7/16, -8/16, -7/16, 7/16, 2/16, 7/16}
        },


        tiles = {
            basedef.tiles[1]
        },

        paramtype = "light",

        sunlight_propagates = true,

        groups = {
            snappy = 1,
            falling_node = 1,
            falling_repose = 1,
            optic_opaque = 1,
            go_stone = 1
        },

        go_team = name,

        sounds = basedef.sounds,

        on_construct = lc_liberties.handle_placement,

        on_dig = lc_liberties.handle_dig,
    })

    local territory_name = modname .. ":territory_" .. string_lower(name)
    minetest.register_node(":" .. territory_name, {
        description = "Territory Marker",
        drawtype = "nodebox",

        node_box = {
            type = "fixed",
            fixed = {
                {-2/16, -8/16, -2/16, 2/16, -7/16, 2/16},
                {-3/16, -7/16, -3/16, 3/16, -6/16, 3/16},
                {-2/16, -6/16, -2/16, 2/16, -5/16, 2/16},
            }
        },

        selection_box = {
            type = "fixed",
            fixed = {-6/16, -8/16, -6/16, 6/16, 0/16, 6/16}
        },


        tiles = {
            basedef.tiles[1]
        },

        paramtype = "light",

        sunlight_propagates = true,

        groups = {
            snappy = 1,
            falling_node = 1,
            falling_repose = 1,
            go_territory_marker = 1,
            stack_as_node = 1,
        },

        go_team = name,

        sounds = basedef.sounds,

        on_place = lc_liberties.handle_territory_fill,

        on_dig = lc_liberties.handle_dig,
    })

    nodecore.register_craft({
        label = "Chop scored cement into go stones",
        action = "pummel",
        toolgroups = {choppy = 3},
        nodes = {
            {
                match = "nc_concrete:" .. name .. "_starcrossy_ply",
                replace = "air"
            }
        },
        items = {{name = piecename, count = 3, scatter = 4}},
    })

    nodecore.register_craft({
        label = "Smash go stones into territory markers",
        action = "pummel",
        toolgroups = {thumpy = 3},
        nodes = {
            {
                match = piecename,
                replace = "air"
            }
        },
        items = {{name = territory_name, count = 9, scatter = 4}},
    })
end

local function buildall()
        for _, v in ipairs(nodecore.registered_concrete_etchables) do
                local basedef = v.name and v.basename and minetest.registered_nodes[v.basename]
                if basedef then
                    reg(v.name, v.basename, basedef)
                end
        end
end

do
        local old_reg_etch = nodecore.register_concrete_etchable
        local function helper(...)
                buildall()
                return ...
        end
        nodecore.register_concrete_etchable = function(...)
                return helper(old_reg_etch(...))
        end
end

buildall()
