-- LUALOCALS < ---------------------------------------------------------
local include, nodecore
    = include, nodecore
-- LUALOCALS > ---------------------------------------------------------

local is_corny_pattern = {}

local function edgify(s)
	return string.gsub(s, "nc_concrete_pattern_corny.png",
		"nc_concrete_pattern_edgy.png")
end

nodecore.register_on_register_item(function(_, def)
	if not def[is_corny_pattern] then return end
	local tiles = def.tiles
	if not tiles then return end
	while #tiles < 6 do tiles[#tiles + 1] = tiles[#tiles] end
	for i = 3, 6 do
		local t = tiles[i]
		if type(t) == "string" then
			tiles[i] = edgify(t)
		elseif type(t) == "table" and t.name then
			t.name = edgify(t.name)
		end
	end
end)

nodecore.register_concrete_pattern({description = "Crossy"})
nodecore.register_concrete_pattern({description = "Starcrossy"})
nodecore.register_concrete_pattern({description = "Edgy", paramtype2 = "4dir"})
nodecore.register_concrete_pattern({description = "Corny", paramtype2 = "4dir",
	[is_corny_pattern] = true})
