-- LUALOCALS < ---------------------------------------------------------
local include, nodecore, pairs, string
    = include, nodecore, pairs, string
local string_lower
    = string.lower
-- LUALOCALS > ---------------------------------------------------------

include("rules")

local modname = minetest.get_current_modname()

local function reg_stone_craft(name, pattern)
    local piecename = modname .. ":stone_" .. string_lower(name)

    nodecore.register_craft({
        label = "chop stones",
        action = "pummel",
        toolgroups = {choppy = 3},
        nodes = {
            {
                match = "nc_concrete:" .. name .. "_" .. pattern .. "_ply",
                replace = "air"
            }
        },
        items = {{name = piecename, count = 3, scatter = 4}},
    })
end

local function reg(name, basename, basedef)
    local piecename = modname .. ":stone_" .. string_lower(name)
    if minetest.registered_nodes[piecename] then return end
    local desc = basedef.description or name

    local nodedesc_base

    local nameStone = string.match(desc, "(.*)stone$")
    if nameStone then
        nodedesc_base = nameStone .. " "
    elseif desc == "Stone" then
        nodedesc_base = ""
    else
        nodedesc_base = desc .. " "
    end

    local stone_selection_box = {
        type = "fixed",
        fixed = {-7/16, -8/16, -7/16, 7/16, 0/16, 7/16}
    }

    minetest.register_node(":" .. piecename, {
        description = nodedesc_base .. "Go Stone",
        drawtype = "mesh",
        mesh = "go_stone.obj",

        selection_box = stone_selection_box,
        collision_box = stone_selection_box,

        tiles = {
            basedef.tiles[1]
        },

        paramtype = "light",

        sunlight_propagates = true,

        groups = {
            snappy = 1,
            falling_node = 1,
            falling_repose = 1,
            optic_opaque = 1,
            go_stone = 1
        },

        go_team = name,

        sounds = basedef.sounds,

        on_construct = lc_liberties.handle_placement,

        on_dig = lc_liberties.handle_dig,

        on_destruct = nodecore.smokeclear,
    })

    local territory_selection_box = {
        type = "fixed",
        fixed = {-5/16, -8/16, -5/16, 5/16, -2/16, 5/16}
    }

    local territory_name = modname .. ":territory_" .. string_lower(name)
    minetest.register_node(":" .. territory_name, {
        description = "Stop Stone",
        drawtype = "nodebox",

        node_box = {
            type = "fixed",
            fixed = {
                {-2/16, -8/16, -2/16, 2/16, -5/16, 2/16},
                {-3/16, -7/16, -3/16, 3/16, -6/16, 3/16},
            }
        },

        selection_box = territory_selection_box,
        collision_box = territory_selection_box,

        node_placement_prediction = "",

        tiles = {
            basedef.tiles[1]
        },

        paramtype = "light",

        sunlight_propagates = true,

        groups = {
            snappy = 1,
            falling_node = 1,
            go_territory_marker = 1,
            stack_as_node = 1,
        },

        go_team = name,

        sounds = basedef.sounds,

        on_place = lc_liberties.handle_territory_fill,

        on_dig = lc_liberties.handle_dig,
    })

    local ko_selection_box = {
        type = "fixed",
        fixed = {-8/16, -8/16, -8/16, 8/16, -4/16, 8/16}
    }

    minetest.register_node(":" .. modname .. ":ko_" .. string_lower(name), {
        description = nodedesc_base .. "Ko Stone",
        drawtype = "nodebox",

        node_box = {
            type = "fixed",
            fixed = {
                {-5/16, -6/16, -5/16, 5/16, -5/16, -4/16},
                {5/16, -6/16, -5/16, 4/16, -5/16, 5/16},
                {5/16, -6/16, 5/16, -5/16, -5/16, 4/16},
                {-5/16, -6/16, 5/16, -4/16, -5/16, -5/16},
            }
        },

        selection_box = ko_selection_box,
        collision_box = ko_selection_box,

        tiles = {basedef.tiles[1]},

        paramtype = "light",
        sunlight_propagates = true,

        groups = {
            snappy = 1,
            stack_as_node = 1,
            ko_stone = 1,
            cheat = 1,
        },

        drop = "",
        destroy_on_dig = true,
        silktouch = false,

        go_team = name,

        sounds = basedef.sounds,

        on_rightclick = lc_liberties.handle_click_ko,
    })

    reg_stone_craft(name, "crossy")
    reg_stone_craft(name, "starcrossy")

    nodecore.register_craft({
        label = "smash stones",
        action = "pummel",
        toolgroups = {thumpy = 3},
        nodes = {
            {
                match = piecename,
                replace = "air"
            }
        },
        items = {{name = territory_name, count = 9, scatter = 4}},
    })
end

local function buildall()
        for _, v in ipairs(nodecore.registered_concrete_etchables) do
                local basedef = v.name and v.basename and minetest.registered_nodes[v.basename]
                if basedef then
                    reg(v.name, v.basename, basedef)
                end
        end
end

do
        local old_reg_etch = nodecore.register_concrete_etchable
        local function helper(...)
                buildall()
                return ...
        end
        nodecore.register_concrete_etchable = function(...)
                return helper(old_reg_etch(...))
        end
end

buildall()
