local S = core.get_translator("digitoilet")

--This part is technically copied from homedecor but probably not copyrightable,
--with it just being the shape of the selection/collision boxes
local toilet_sbox = {
	type = "fixed",
	fixed = { -6/16, -8/16, -8/16, 6/16, 9/16, 8/16 },
}

local toilet_cbox = {
	type = "fixed",
	fixed = {
		{-6/16, -8/16, -8/16, 6/16, 0, 8/16 },
		{-6/16, -8/16, 4/16, 6/16, 9/16, 8/16 }
	}
}
--Copied part ends here

local function handlefields(pos,_,fields,player)
	if not (fields.channel and player:is_player()) then
		return
	end
	local name = player:get_player_name()
	if core.is_protected(pos,name) and not core.check_player_privs(name,{protection_bypass=true}) then
		core.record_protection_violation(pos,name)
		return
	end
	core.get_meta(pos):set_string("channel",fields.channel)
end

local function handledigilines(pos,node,channel,msg)
	if channel ~= core.get_meta(pos):get_string("channel") then return end
	if type(msg) ~= "string" then return end
	msg = string.lower(msg)
	if msg == "open" then
		node.name = "digitoilet:toilet_open"
		core.swap_node(pos,node)
	elseif msg == "close" then
		node.name = "digitoilet:toilet_closed"
		core.swap_node(pos,node)
	elseif msg == "flush" then
		core.sound_play("homedecor_toilet_flush", {
			pos = pos,
			max_hear_distance = 10,
		})
	elseif msg == "spray" then
		if node.name ~= "digitoilet:toilet_open" then return end
		local dir = core.fourdir_to_dir(node.param2)
		dir = vector.rotate_around_axis(dir,vector.new(0,1,0),math.pi)
		core.add_particlespawner({
			amount = 300,
			time = 2.5,
			size = 1,
			glow = 10,
			collisiondetection = true,
			object_collision = true,
			texture = "homedecor_water_particle.png",
			pos = {
				min = pos,
				max = pos,
			},
			vel = {
				min = vector.add(vector.multiply(dir,4),vector.new(0,4,0)),
				max = vector.add(vector.multiply(dir,5),vector.new(0,5,0)),
			},
			acc = {
				min = vector.new(0,-1.5,0),
				max = vector.new(0,-1,0),
			},
			exptime = {
				min = 8,
				max = 10,
			},
			drag = {
				min = vector.new(0.7,0,0.7),
				max = vector.new(0.9,0,0.9),
			},
		})
		core.sound_play("homedecor_faucet", {
			pos = pos,
			max_hear_distance = 10,
		})
	elseif msg == "overflow" then
		if node.name ~= "digitoilet:toilet_open" then return end
		core.add_particlespawner({
			amount = 150,
			time = 2.5,
			size = 1,
			glow = 10,
			collisiondetection = true,
			object_collision = true,
			texture = "homedecor_water_particle.png",
			pos = {
				min = pos,
				max = pos,
			},
			vel = {
				min = vector.new(-0.5,0,-0.5),
				max = vector.new(0.5,0,0.5),
			},
			acc = {
				min = vector.new(0,-1.5,0),
				max = vector.new(0,-1,0),
			},
			exptime = {
				min = 8,
				max = 10,
			},
		})
		core.sound_play("homedecor_toilet_flush", {
			pos = pos,
			max_hear_distance = 10,
		})
	end
end

core.register_node("digitoilet:toilet_closed", {
	description = S("Digilines-Controlled Toilet"),
	drawtype = "mesh",
	paramtype = "light",
	paramtype2 = "4dir",
	mesh = "homedecor_toilet_closed.obj",
	tiles = {
		"building_blocks_marble.png",
		"building_blocks_marble.png",
		"building_blocks_marble.png",
		"homedecor_generic_metal.png^[colorize:#495dc244",
	},
	selection_box = toilet_sbox,
	node_box = toilet_cbox,
	groups = {cracky=3,},
	on_construct = function(pos)
		local meta = core.get_meta(pos)
		meta:set_string("formspec","field[channel;"..S("Channel")..";${channel}]")
	end,
	on_receive_fields = handlefields,
	digilines = {
		receptor = {},
		effector = {
			action = handledigilines,
		},
	},
})

core.register_node("digitoilet:toilet_open", {
	description = S("Digilines-Controlled Toilet (open)"),
	drawtype = "mesh",
	paramtype = "light",
	paramtype2 = "4dir",
	drop = "digitoilet:toilet_closed",
	mesh = "homedecor_toilet_open.obj",
	tiles = {
		"building_blocks_marble.png",
		"building_blocks_marble.png",
		"building_blocks_marble.png",
		"default_water.png",
		"homedecor_generic_metal.png^[colorize:#495dc244",
	},
	selection_box = toilet_sbox,
	node_box = toilet_cbox,
	groups = {cracky=3,not_in_creative_inventory=1},
	on_construct = function(pos)
		local meta = core.get_meta(pos)
		meta:set_string("formspec","field[channel;"..S("Channel")..";${channel}]")
	end,
	on_receive_fields = handlefields,
	digilines = {
		receptor = {},
		effector = {
			action = handledigilines,
		},
	},
})

core.register_craft({
	type = "shapeless",
	output = "digitoilet:toilet_closed",
	recipe = {"homedecor:toilet","digilines:wire_std_00000000"},
})
