local caps_message_count={}

local caps_percentage = function(message)
	local upper = message:upper()
	local lower = message:lower()
	local total = 0
	if message:lower() ~= message then
		for i = 1,message:len() do
			local mletter = message:sub(i, i)
			local cletter = upper:sub(i, i)
			local lletter = lower:sub(i, i)
			if (mletter == cletter) and (mletter ~= lletter)  then total = total + 1 end
		end
		return total/message:len()
	else
		return 0
	end
end

minetest.register_on_joinplayer(function(player)
	local player_name = player:get_player_name()
	caps_message_count[player_name] = 0
end)

minetest.register_on_leaveplayer(function(player)
	local player_name = player:get_player_name()
	caps_message_count[player_name] = nil
end)

minetest.register_on_chat_message(function(name, message)
	if minetest.get_player_privs(name).basic_privs~=true and message:len()>16 and caps_percentage(message)>0.5 then
		caps_message_count[name] = caps_message_count[name] + 1
		if caps_message_count[name]>=3 then
			minetest.kick_player(name,"Used too many capital letters")
			minetest.chat_send_all(string.format("* %s was kicked for using too many capital letters.",name))
			if minetest.get_modpath("irc") then irc.say(string.format("* %s was kicked for using too many capital letters.",name)) end
			minetest.log("action", string.format("Kicked %s for using too many capital letters",name))
		else
			if minetest.get_modpath("notice") then
				notice.send(name,"You are using too many capital letters.")
			else
				minetest.chat_send_player(name,"You are using too many capital letters.")
			end
			minetest.log("action",string.format("%s was warned for sending an all-caps message (%u so far)",name,caps_message_count[name]))
		end
	end
end)
